/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.IDMapping;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import com.ibm.uclab.csrepl.ptrstore.PtrStoreFS;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

class IDMappingReaderImpl
implements IDMappingReader {
    private static final int PAGE_DIGIT_COUNT = 4;
    private static final String PTRS_PREFIX = "ptrs-";
    private final PtrStoreFS store;
    private Iterator<String> nameItr;
    private Iterator<IDMapping> mappingItr;
    private boolean closed;

    IDMappingReaderImpl(PtrStoreFS store) {
        this.store = store;
        String[] list = store.getPageDir().list();
        this.nameItr = list == null ? Collections.emptyList().iterator() : Arrays.asList(list).iterator();
    }

    @Override
    public IDMapping read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        return this.advance();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.nameItr = null;
        this.mappingItr = null;
    }

    private IDMapping advance() throws IOException {
        if (this.nameItr == null) {
            return null;
        }
        while (true) {
            if (this.mappingItr == null) {
                if (!this.nameItr.hasNext()) {
                    this.nameItr = null;
                    return null;
                }
                String name = this.nameItr.next();
                if (!this.isPage(name)) continue;
                this.mappingItr = this.read(name);
                if (this.mappingItr == null) continue;
            }
            if (this.mappingItr.hasNext()) break;
            this.mappingItr = null;
        }
        return this.mappingItr.next();
    }

    private boolean isPage(String name) {
        if (name.length() != PTRS_PREFIX.length() + 4) {
            return false;
        }
        if (!name.startsWith(PTRS_PREFIX)) {
            return false;
        }
        String num = name.substring(PTRS_PREFIX.length());
        for (int i = 0; i < num.length(); ++i) {
            if (this.isHex(num.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<IDMapping> read(String name) throws IOException {
        Map<UUID, IDMapping> m;
        int page = this.getPageNumber(name);
        this.store.lockByPage(page);
        try {
            File f = new File(this.store.getPageDir(), name);
            m = this.store.read(f);
        }
        finally {
            this.store.unlockByPage(page);
        }
        if (m == null) {
            return null;
        }
        return Collections.unmodifiableCollection(m.values()).iterator();
    }

    private boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private int getPageNumber(String name) {
        return Integer.parseInt(name.substring(PTRS_PREFIX.length()), 16);
    }
}

