/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.IDMapping;
import com.ibm.uclab.csrepl.ptrstore.PageFileGroup;
import com.ibm.uclab.csrepl.ptrstore.PtrStoreFS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class PageFileGroupImpl
implements PageFileGroup,
Comparable<PageFileGroupImpl> {
    private final PtrStoreFS store;
    private final int lockIndex;
    private final List<File> files;

    PageFileGroupImpl(PtrStoreFS store, int lockIndex, List<File> files) {
        this.store = store;
        this.lockIndex = lockIndex;
        this.files = new ArrayList<File>(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDMapping> readAsList() throws IOException {
        ArrayList<IDMapping> mappings = new ArrayList<IDMapping>();
        this.store.lockByLockIndex(this.lockIndex);
        try {
            for (File f : this.files) {
                Map<UUID, IDMapping> m = this.store.read(f);
                if (m == null) continue;
                mappings.addAll(m.values());
            }
        }
        finally {
            this.store.unlockByLockIndex(this.lockIndex);
        }
        return Collections.unmodifiableList(mappings);
    }

    @Override
    public int compareTo(PageFileGroupImpl o) {
        if (this.lockIndex < o.lockIndex) {
            return -1;
        }
        if (this.lockIndex == o.lockIndex) {
            return 0;
        }
        return 1;
    }
}

