/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.asm.ArtifactSetManagerLookup;
import com.ibm.uclab.csrepl.asm.security.AsmResourceSecurity;
import com.ibm.uclab.csrepl.asm.security.AsmResourceSecurityLookup;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.rest.ArtifactsResource;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.IDMappingEntity;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="asm")
public class AsmResource {
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final Errors errors = new Errors(log);
    private static final AtomicLong counter = new AtomicLong();
    private final ArtifactSetManager asm;
    private final AsmResourceSecurity security;

    public AsmResource() {
        this(ArtifactSetManagerLookup.get(), AsmResourceSecurityLookup.get());
    }

    public AsmResource(ArtifactSetManager asm, AsmResourceSecurity security) {
        this.asm = asm;
        this.security = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../asm/status", op));
        }
        try {
            this.getASM();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    @GET
    @Path(value="mappings")
    @Produces(value={"text/plain"})
    public Response getMappings() throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../asm/mappings", op));
        }
        try {
            this.assertCanGetMappings();
            ArtifactSetManager asm = this.getASM();
            IDMappingEntity entity = new IDMappingEntity(asm);
            Map<String, String> charset = Collections.singletonMap("charset", "UTF-8");
            MediaType type = new MediaType("text", "plain", charset);
            response = Response.ok((Object)entity, (MediaType)type).build();
        }
        catch (Exception e) {
            try {
                throw errors.mapException(e);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("[op=%d] Complete", op));
                }
                throw throwable;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * Loose catch block
     */
    @GET
    @Path(value="artifactSet/{artifactSetId}")
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="artifactSetId") UUIDParam artifactSetId) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../asm/artifactSet/%s", op, artifactSetId));
        }
        ArtifactSetManager asm = this.getASM();
        UUID asid = artifactSetId.getUUID();
        this.assertCanReadMapping(asid);
        UUID blobId = asm.getBlobId(asid);
        if (blobId == null) {
            throw errors.notFound("Artifact set not found: " + asid);
        }
        Response response = Response.ok((Object)blobId.toString()).build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @PUT
    @Path(value="artifactSet/{artifactSetId}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response set(@PathParam(value="artifactSetId") UUIDParam artifactSetId, UUIDParam blobId) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] PUT .../asm/artifactSet/%s", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Body: %s", op, blobId));
        }
        ArtifactSetManager asm = this.getASM();
        UUID asid = artifactSetId.getUUID();
        UUID bid = blobId.getUUID();
        this.assertCanCreateMapping(asid);
        asm.setBlobId(asid, bid);
        Response response = Response.noContent().build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @POST
    @Path(value="compareAndSet")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response compareAndSet(@FormParam(value="artifactSetId") UUIDParam artifactSetId, @FormParam(value="oldBlobId") UUIDParam oldBlobId, @FormParam(value="newBlobId") UUIDParam newBlobId) throws Exception {
        long op;
        block12: {
            op = counter.getAndIncrement();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] POST .../asm/compareAndSet", op));
                log.trace((Object)String.format("[op=%d] FormParam: %s=%s", op, "artifactSetId", artifactSetId));
                log.trace((Object)String.format("[op=%d] FormParam: %s=%s", op, "oldBlobId", oldBlobId));
                log.trace((Object)String.format("[op=%d] FormParam: %s=%s", op, "newBlobId", newBlobId));
            }
            ArtifactSetManager asm = this.getASM();
            UUID asid = artifactSetId.getUUID();
            UUID oldBid = oldBlobId.getUUID();
            UUID newBid = newBlobId.getUUID();
            if (oldBid == null) {
                this.assertCanCreateMapping(asid);
            } else {
                this.assertCanUpdateMapping(asid);
            }
            UUID curBid = asm.compareAndSetBlobId(asid, oldBid, newBid);
            if (curBid == null) break block12;
            Response response = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)curBid.toString()).type(MediaType.TEXT_PLAIN_TYPE).build();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            return response;
        }
        Response response = Response.noContent().build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    private ArtifactSetManager getASM() {
        if (this.asm == null) {
            throw errors.notImplemented("Artifact set manager unavailable");
        }
        return this.asm;
    }

    public synchronized AsmResourceSecurity getSecurity() {
        return this.security;
    }

    private void assertCanGetMappings() {
        try {
            AsmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanGetMappings();
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }

    private void assertCanReadMapping(UUID artifactSetId) {
        try {
            AsmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanReadMapping(artifactSetId);
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }

    private void assertCanCreateMapping(UUID artifactSetId) {
        try {
            AsmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanCreateMapping(artifactSetId);
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }

    private void assertCanUpdateMapping(UUID artifactSetId) {
        try {
            AsmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanUpdateMapping(artifactSetId);
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }
}

