/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.blobstore.OpenBlobResponse;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.bm.BlobManagerLookup;
import com.ibm.uclab.csrepl.bm.security.BmResourceSecurity;
import com.ibm.uclab.csrepl.bm.security.BmResourceSecurityLookup;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.rest.ArtifactsResource;
import com.ibm.uclab.csrepl.rest.ByteRangeHeaderParam;
import com.ibm.uclab.csrepl.rest.DigestParam;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.IOExceptionLoggingInputStream;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;

@Path(value="bm")
public class BmResource {
    static final int PARTIAL_CONTENT = 206;
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final Errors errors = new Errors(log);
    private static final AtomicLong counter = new AtomicLong();
    private final BlobManager bm;
    private final BmResourceSecurity security;

    public BmResource() {
        this(BlobManagerLookup.get(), BmResourceSecurityLookup.get());
    }

    public BmResource(BlobManager bm, BmResourceSecurity security) {
        this.bm = bm;
        this.security = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/status", op));
        }
        try {
            this.getBM();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="blob/{blobId}")
    @Produces(value={"application/octet-stream"})
    public Response getBlob(@PathParam(value="blobId") UUIDParam blobId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Range") ByteRangeHeaderParam rangeHeader) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/blob/%s", op, blobId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            response = this.doGetBlob(blobId, digest, rangeHeader, false);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="localBlob/{blobId}")
    @Produces(value={"application/octet-stream"})
    public Response getLocalBlob(@PathParam(value="blobId") UUIDParam blobId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Range") ByteRangeHeaderParam rangeHeader) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../bm/localBlob/%s", op, blobId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            response = this.doGetBlob(blobId, digest, rangeHeader, true);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * Loose catch block
     */
    @POST
    @Path(value="addBlob")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public Response addBlob(InputStream in, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest) throws Exception {
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../bm/addBlob", op));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        BlobManager bm = this.getBM();
        this.assertCanCreateBlob();
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null) {
            in = new HashCheckingInputStream(in, dig);
        }
        UUID id = bm.addBlob(in);
        URI location = UriBuilder.fromResource(BmResource.class).path(BmResource.class, "getBlob").build(new Object[]{id});
        Response.ResponseBuilder resb = Response.created((URI)location);
        resb.header("X-Codestation-Blob-ID", (Object)id.toString());
        Response response = resb.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
        {
            catch (Exception e) {
                try {
                    throw errors.mapException(e);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("[op=%d] Complete", op));
                    }
                    throw throwable;
                }
            }
        }
    }

    Response doGetBlob(UUIDParam blobIdParam, DigestParam digestHeader, ByteRangeHeaderParam rangeHeader, boolean localOnly) throws Exception {
        BlobManager bm = this.getBM();
        UUID blobId = blobIdParam.getUUID();
        this.assertCanReadBlob(blobId);
        try {
            Response.ResponseBuilder resb;
            OpenBlobResponse blobResp;
            ByteRange range;
            MessageDigest digest = null;
            if (digestHeader != null) {
                digest = digestHeader.getDigest();
            }
            if ((range = this.getRange(rangeHeader)) != null) {
                digest = null;
            }
            if ((blobResp = localOnly ? bm.openBlobLocal(blobId, range) : bm.openBlob(blobId, range)) == null) {
                throw errors.notFound("Blob not found: " + blobId);
            }
            if (digest != null) {
                blobResp.setContent(new HashInjectingInputStream(blobResp.getContent(), digest));
            }
            blobResp.setContent(new IOExceptionLoggingInputStream(blobResp.getContent()));
            long blobLength = blobResp.getBlobLength();
            if (range != null) {
                resb = Response.status((int)206).entity((Object)blobResp.getContent());
                resb.header("Content-Range", (Object)blobResp.getContentRange());
                long rangeLength = range.getAbsoluteLength(blobLength);
                if (rangeLength != 1L) {
                    resb.header("Content-Length", (Object)rangeLength);
                }
            } else {
                resb = Response.ok((Object)blobResp.getContent());
                if (blobLength != -1L) {
                    long contentLength = blobLength;
                    if (digest != null) {
                        contentLength += (long)digest.getDigestLength();
                    }
                    resb.header("Content-Length", (Object)contentLength);
                }
            }
            resb.type(MediaType.APPLICATION_OCTET_STREAM_TYPE);
            resb.header("X-Codestation-Blob-ID", (Object)blobId.toString());
            resb.header("Accept-Ranges", (Object)"bytes");
            if (digest != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)digest.getAlgorithm());
            }
            return resb.build();
        }
        catch (Exception e) {
            throw errors.mapException(e);
        }
    }

    private ByteRange getRange(ByteRangeHeaderParam header) {
        List<ByteRange> ranges;
        ByteRange range = null;
        if (header != null && !(ranges = header.getRanges()).isEmpty()) {
            if (ranges.size() > 1) {
                throw errors.badRequest("Multiple byte ranges not supported");
            }
            range = ranges.get(0);
        }
        return range;
    }

    private BlobManager getBM() {
        if (this.bm == null) {
            throw errors.notImplemented("Blob manager unavailable");
        }
        return this.bm;
    }

    synchronized BmResourceSecurity getSecurity() {
        return this.security;
    }

    private synchronized void assertCanReadBlob(UUID blobId) {
        try {
            BmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanReadBlob(blobId);
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }

    private synchronized void assertCanCreateBlob() {
        try {
            BmResourceSecurity security = this.getSecurity();
            if (security != null) {
                security.assertCanCreateBlob();
            }
        }
        catch (CodestationSecurityException e) {
            throw errors.mapException(e);
        }
    }
}

