/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.blobstore.UnsatisfiableRangeException;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.AuthorizationException;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.exceptions.CorruptStreamException;
import com.ibm.uclab.csrepl.exceptions.ServerFailedException;
import com.ibm.uclab.csrepl.exceptions.ServerUnavailableException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerFailedException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerUnavailableException;
import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.log4j.Logger;

public final class Errors {
    private final Logger log;

    public Errors(Logger log) {
        log.getClass();
        this.log = log;
    }

    WebApplicationException notFound(String message) {
        return this.notFound(message, null);
    }

    WebApplicationException notFound(String message, Throwable cause) {
        return this.createException(Response.Status.NOT_FOUND, message, cause);
    }

    WebApplicationException badRequest(String message) {
        return this.badRequest(message, null);
    }

    WebApplicationException badRequest(String message, Throwable cause) {
        return this.createException(Response.Status.BAD_REQUEST, message, cause);
    }

    WebApplicationException serviceUnavailable(String message) {
        return this.serviceUnavailable(message, null);
    }

    WebApplicationException serviceUnavailable(String message, Throwable cause) {
        return this.createException(Response.Status.SERVICE_UNAVAILABLE, message, cause);
    }

    WebApplicationException unauthorized(String message) {
        return this.unauthorized(message, null);
    }

    WebApplicationException unauthorized(String message, Throwable cause) {
        return this.createException(Response.Status.UNAUTHORIZED, message, cause);
    }

    WebApplicationException forbidden(String message) {
        return this.forbidden(message, null);
    }

    WebApplicationException forbidden(String message, Throwable cause) {
        return this.createException(Response.Status.FORBIDDEN, message, cause);
    }

    WebApplicationException internalServerError(String message) {
        return this.internalServerError(message, null);
    }

    WebApplicationException internalServerError(String message, Throwable cause) {
        return this.createException(Response.Status.INTERNAL_SERVER_ERROR, message, cause);
    }

    public WebApplicationException notImplemented(String message) {
        return this.notImplemented(message, null);
    }

    WebApplicationException notImplemented(String message, Throwable cause) {
        return this.createException(501, message, cause);
    }

    public WebApplicationException badGateway(String message) {
        return this.badGateway(message, null);
    }

    WebApplicationException badGateway(String message, Throwable cause) {
        return this.createException(502, message, cause);
    }

    WebApplicationException gatewayTimeout(String message) {
        return this.gatewayTimeout(message, null);
    }

    WebApplicationException gatewayTimeout(String message, Throwable cause) {
        return this.createException(504, message, cause);
    }

    WebApplicationException requestedRangeNotSatisfiable(String message, long entityLength, Throwable cause) {
        Response.ResponseBuilder builder = this.initExceptionResponseBuilder(416, message);
        builder.header("Content-Range", (Object)ByteContentRange.forUnsatisfiedRange(entityLength));
        return this.createException(builder.build(), cause);
    }

    <T extends Throwable> T mapException(T e) {
        if (e instanceof WebApplicationException) {
            return e;
        }
        if (e instanceof UnsatisfiableRangeException) {
            long actualBlobLength = ((UnsatisfiableRangeException)e).getActualBlobLength();
            if (actualBlobLength < 0L) {
                throw this.internalServerError("Entity length unavailable: " + e.getMessage(), e);
            }
            throw this.requestedRangeNotSatisfiable("Range not satisfiable: " + e.getMessage(), actualBlobLength, e);
        }
        if (e instanceof ConnectionPoolTimeoutException) {
            throw this.serviceUnavailable("Connection pool exhausted: " + e.getMessage(), e);
        }
        if (e instanceof ConnectTimeoutException) {
            throw this.gatewayTimeout("Connection to upstream server timed out: " + e.getMessage(), e);
        }
        if (e instanceof AuthenticationException) {
            throw this.unauthorized("Cannot authenticate with peer: " + e.getMessage(), e);
        }
        if (e instanceof AuthorizationException) {
            throw this.forbidden("Not authorized: " + e.getMessage(), e);
        }
        if (e instanceof ServerUnavailableException) {
            throw this.gatewayTimeout("Upstream server unavailable: " + e.getMessage(), e);
        }
        if (e instanceof UpstreamServerFailedException) {
            throw this.badGateway("Upstream server failed: " + e.getMessage(), e);
        }
        if (e instanceof UpstreamServerUnavailableException) {
            throw this.gatewayTimeout("Upstream server unavailable: " + e.getMessage(), e);
        }
        if (e instanceof ServerFailedException) {
            throw this.badGateway("Upstream server failed: " + e.getMessage(), e);
        }
        if (e instanceof CorruptStreamException) {
            throw this.badRequest("Transfer aborted: " + e.getMessage(), e);
        }
        if (e instanceof UnsupportedOperationException) {
            throw this.forbidden("Unsupported operation: " + e.getMessage(), e);
        }
        if (e instanceof CodestationSecurityException) {
            throw this.forbidden(e.getMessage(), e);
        }
        return e;
    }

    private WebApplicationException createException(Response.Status status, String message, Throwable cause) {
        return this.createException(this.createExceptionResponse(status, message).build(), cause);
    }

    private WebApplicationException createException(int status, String message, Throwable cause) {
        return this.createException(this.initExceptionResponseBuilder(status, message).build(), cause);
    }

    private WebApplicationException createException(Response response, Throwable cause) {
        String message = null;
        if (cause != null) {
            message = cause.getMessage();
        }
        WebApplicationException e = new WebApplicationException(message, cause, response);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Created WebApplicationException", (Throwable)e);
        }
        return e;
    }

    private Response.ResponseBuilder createExceptionResponse(Response.Status status, String message) {
        if (message != null) {
            message = message.trim() + "\r\n";
        }
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).header("X-Content-Type-Options", (Object)"nosniff").entity((Object)message);
    }

    private Response.ResponseBuilder initExceptionResponseBuilder(int status, String message) {
        if (message != null) {
            message = message.trim() + "\r\n";
        }
        return Response.status((int)status).type(MediaType.TEXT_PLAIN_TYPE).header("X-Content-Type-Options", (Object)"nosniff").entity((Object)message);
    }
}

