/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.rest.Errors;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;

public class MediaTypeParam {
    private static final Logger log = Logger.getLogger(MediaTypeParam.class);
    private static final Errors errors = new Errors(log);
    private final String text;
    private MediaType type;

    public static MediaType toType(MediaTypeParam param) {
        if (param == null) {
            return null;
        }
        return param.getType();
    }

    public MediaTypeParam() {
        this.text = null;
    }

    public MediaTypeParam(String text) {
        this.text = text;
    }

    public String toString() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public MediaType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.text == null) {
            return null;
        }
        String text = this.text.trim();
        if (text.length() == 0) {
            return null;
        }
        try {
            this.type = MediaType.valueOf((String)text);
            return this.type;
        }
        catch (IllegalArgumentException e) {
            throw errors.badRequest("Invalid media type: " + text, e);
        }
    }
}

