/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Verify;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class VerifyLocalArtifactsCommand {
    public static void main(String[] args) throws Exception {
        File workDir;
        AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
        Properties props = apTool.getStepProperties();
        String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
        UUID versionId = UUID.fromString(props.getProperty("versionId"));
        String directoryOffset = props.getProperty("directoryOffset");
        String fileIncludePatterns = props.getProperty("fileIncludePatterns");
        String fileExcludePatterns = props.getProperty("fileExcludePatterns");
        File baseDirectory = workDir = new File(".").getCanonicalFile();
        if (directoryOffset != null) {
            baseDirectory = new File(workDir, directoryOffset).getCanonicalFile();
        }
        List<String> includes = Util.parseLines(fileIncludePatterns);
        List<String> excludes = Util.parseLines(fileExcludePatterns);
        if (baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + baseDirectory + " is a file");
        }
        Util.configureLogging();
        CodestationClient csClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
        Verify op = new Verify(csClient, baseDirectory, versionId);
        op.setIncludes(includes);
        op.setExcludes(excludes);
        op.setSlowVerification(true);
        System.out.println("Artifact source: " + csClient.getUrl());
        System.out.println("Verifying files in " + baseDirectory);
        System.out.println("Including " + includes);
        System.out.println("Excluding " + excludes);
        op.run();
        if (op.getFailureCount() > 0) {
            System.exit(1);
        } else {
            System.out.println("All files match.");
            System.exit(0);
        }
    }
}

