/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.compare;

import com.urbancode.commons.util.processes.Processes;
import com.urbancode.plugins.ucd.vfs.zos.compare.DatasetType;
import java.io.File;
import java.util.concurrent.Future;

class FilesComparator {
    private final String workDirPath;

    public FilesComparator(String workDirPath) {
        this.workDirPath = workDirPath;
    }

    public void compare(String dataSetFile1, String dataSetFile2, DatasetType datasetType) throws Exception {
        Processes processes = new Processes();
        String[] cmdArgs = new String[]{"diff", "-sc", dataSetFile1, dataSetFile2};
        Process process = new ProcessBuilder(cmdArgs).directory(new File(this.workDirPath)).start();
        process.getOutputStream().close();
        Future<String> sout = processes.getOutputStringFuture(process);
        Future<String> serr = processes.getErrorStringFuture(process);
        int exitValue = process.waitFor();
        if (exitValue == 0 && datasetType == DatasetType.SEQ) {
            System.out.println("Files " + dataSetFile1 + " and " + dataSetFile2 + " are identical");
        } else if (exitValue < 2) {
            System.out.println(sout.get());
        } else {
            System.out.println(" [ERROR] Comparison process failed with code - " + exitValue);
            System.out.println("Process Output : \n" + sout.get());
            System.out.println("Process Error : \n" + serr.get());
            throw new Exception(" [ERROR] Failed to find differences between file " + dataSetFile1 + " and " + dataSetFile2);
        }
    }
}

