/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.compare;

import com.urbancode.plugins.ucd.vfs.zos.compare.Dataset;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PackageManifest {
    private static final String FILE_ENCODING = "file.encoding";
    private static final String DELETED = "deleted";
    private static final String CONTAINER = "container";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String PDS = "PDS";
    private static final String SEQUENTIAL = "sequential";
    private static final String ATTRIBUTE_COPY_TYPE = "copyType";
    private static final String COPY_TYPE_TEXT = "TEXT";
    private final List<Dataset> textDatasets = new ArrayList<Dataset>();
    private boolean isDeleted = false;

    public static PackageManifest from(String manifestFilePath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = new PackageManifest();
        try (InputStream inputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            packageManifest.parse(inputStream);
        }
        return packageManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, this.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private String getFileEncoding() {
        String fileEncoding = System.getProperty(FILE_ENCODING);
        if (fileEncoding == null) {
            throw new RuntimeException("Property file.encoding not found");
        }
        return fileEncoding;
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase(DELETED)) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase(CONTAINER) && !this.isDeleted) {
            this.processContainerTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String name = this.getAttributeValue(xmlStreamReader, ATTRIBUTE_NAME);
        if (name == null) {
            throw new RuntimeException("Container name attribute not found");
        }
        String type = this.getAttributeValue(xmlStreamReader, ATTRIBUTE_TYPE);
        if (type == null) {
            throw new RuntimeException("Container type attribute not found");
        }
        String copyType = this.getAttributeValue(xmlStreamReader, ATTRIBUTE_COPY_TYPE);
        if (copyType == null) {
            throw new RuntimeException("Container copyType attribute not found for dataset container " + name);
        }
        if ((type.equalsIgnoreCase(PDS) || type.equalsIgnoreCase(SEQUENTIAL)) && copyType.equalsIgnoreCase(COPY_TYPE_TEXT)) {
            Dataset textDataset = new Dataset(name, type);
            this.textDatasets.add(textDataset);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase(DELETED)) {
            this.isDeleted = false;
        }
    }

    public String getAttributeValue(XMLStreamReader xmlStreamReader, String attributeName) {
        String attributeValue = xmlStreamReader.getAttributeValue(null, attributeName);
        if (attributeValue != null) {
            return attributeValue.trim();
        }
        return null;
    }

    public List<String> getTextPdsDatasets() {
        return this.textDatasets.stream().filter(this::isPds).map(Dataset::getName).collect(Collectors.toList());
    }

    public List<String> getTextSequentialDatasets() {
        return this.textDatasets.stream().filter(this::isSequential).map(Dataset::getName).collect(Collectors.toList());
    }

    private boolean isPds(Dataset dataset) {
        return dataset.getType().equalsIgnoreCase(PDS);
    }

    private boolean isSequential(Dataset dataset) {
        return dataset.getType().equalsIgnoreCase(SEQUENTIAL);
    }
}

