/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.helpers;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class VersionDownloader {
    private final String serverUrl;
    private final AirPluginTool apTool;

    public VersionDownloader(String serverUrl, AirPluginTool apTool) {
        this.serverUrl = serverUrl;
        this.apTool = apTool;
    }

    public void download(String versionId, String directoryPath) throws Exception {
        this.download(UUID.fromString(versionId), directoryPath);
    }

    public void download(UUID versionId, String directoryPath) throws Exception {
        Util.configureLogging();
        CodestationClient codestationClient = this.getCodestationClient();
        System.out.println("Artifact source: " + codestationClient.getUrl());
        Download downloadTask = new Download(codestationClient, new File(directoryPath), versionId);
        downloadTask.setIncludes(this.getFilesToDownload());
        downloadTask.setOutputCharset(Util.getSystemCharset());
        downloadTask.run();
        System.out.println();
    }

    private CodestationClient getCodestationClient() {
        return Util.getCodestationClient(this.serverUrl, false, this.apTool.getAuthTokenUsername(), this.apTool.getAuthToken());
    }

    private List<String> getFilesToDownload() {
        return Arrays.asList("package.zip", "packageManifest.xml", "versionChecksum.properties");
    }
}

