/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExecuteOnlyPermissionReader
extends PermissionReader {
    private final PermissionReader delegate;

    FileExecuteOnlyPermissionReader(PermissionReader delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    Set<?> getPermissions(File file) throws IOException {
        Set<Object> result = Collections.emptySet();
        if (file.isFile()) {
            Set<?> permissions = this.delegate.getPermissions(file);
            for (Object view : permissions) {
                if (!(view instanceof UnixPermissions)) continue;
                int mode = 420;
                UnixPermissions perms = (UnixPermissions)view;
                if (perms.isUserExecutable()) {
                    mode |= 0x40;
                }
                if (perms.isGroupExecutable()) {
                    mode |= 8;
                }
                if (perms.isOtherExecutable()) {
                    mode |= 1;
                }
                if (mode == 0) continue;
                perms = UnixPermissions.createFromNumeric((int)mode, (String)"", (String)"");
                result = Collections.singleton(perms);
            }
        }
        return result;
    }
}

