/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.checksum;

import com.ibm.urbancode.zos.checksum.InvalidChecksumException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Properties;

public class ChecksumVerifier {
    public static final String PACKAGE_CHECKSUM = "PACKAGE-CHECKSUM";
    public static final String MANIFEST_CHECKSUM = "MANIFEST-CHECKSUM";
    public static final String CHECKSUM_ALGORITHM = "CHECKSUM-ALGORITHM";
    private static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String VERSION_CHECKSUM_PROPERTIES = "versionChecksum.properties";
    private static final int bufferSize = 0x100000;
    private final String directory;
    private final Properties versionChecksumProperties = new Properties();

    private ChecksumVerifier(String directory) {
        this.directory = directory;
    }

    public static void verify(String directory) throws GeneralSecurityException, IOException, InvalidChecksumException {
        ChecksumVerifier checksumVerifier = new ChecksumVerifier(directory);
        checksumVerifier.verify();
    }

    private void verify() throws IOException, GeneralSecurityException, InvalidChecksumException {
        System.out.println("Verifying checksum for files in " + this.directory);
        this.loadVersionChecksumProperties(this.directory + File.separator + VERSION_CHECKSUM_PROPERTIES);
        if (this.versionChecksumProperties.containsKey(PACKAGE_CHECKSUM)) {
            this.assertChecksumForPackageZip();
        }
        this.assertChecksumForManifest();
        System.out.println();
    }

    private void assertChecksumForPackageZip() throws IOException, GeneralSecurityException, InvalidChecksumException {
        String packageZipChecksum = this.versionChecksumProperties.getProperty(PACKAGE_CHECKSUM);
        if (!packageZipChecksum.equalsIgnoreCase(this.getFileChecksum(PACKAGE_ZIP))) {
            throw new InvalidChecksumException("Checksum for file package.zip did not match");
        }
        System.out.println("Verified checksum for file package.zip");
    }

    private void assertChecksumForManifest() throws IOException, GeneralSecurityException, InvalidChecksumException {
        String manifestChecksum = this.versionChecksumProperties.getProperty(MANIFEST_CHECKSUM);
        if (!manifestChecksum.equalsIgnoreCase(this.getFileChecksum(PACKAGE_MANIFEST_XML))) {
            throw new InvalidChecksumException("Checksum for file packageManifest.xml did not match");
        }
        System.out.println("Verified checksum for file packageManifest.xml");
    }

    private String getFileChecksum(String fileName) throws GeneralSecurityException, IOException {
        String filePath = this.directory + File.separator + fileName;
        MessageDigest messageDigest = MessageDigest.getInstance(this.versionChecksumProperties.getProperty(CHECKSUM_ALGORITHM));
        try (BufferedInputStream buffInputStream = new BufferedInputStream(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            int length;
            byte[] buffer = new byte[0x100000];
            while ((length = buffInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
            }
        }
        return this.getHexString(messageDigest.digest());
    }

    private String getHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private void loadVersionChecksumProperties(String propertiesFilePath) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(Paths.get(propertiesFilePath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
            this.versionChecksumProperties.load(inputStreamReader);
        }
    }
}

