/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public class ArtifactSetReaderInputStream
extends InputStream {
    private static final SecureRandom rand = new SecureRandom();
    private static final byte[] boundaryAlphabet = ArtifactSetReaderInputStream.toASCII("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    private static final byte[] crlf = ArtifactSetReaderInputStream.toASCII("\r\n");
    private static final byte[] encodingHeader = ArtifactSetReaderInputStream.toASCII("Content-Transfer-Encoding: binary\r\n");
    private static final byte[] startBoundary = ArtifactSetReaderInputStream.toASCII("\r\n--");
    private static final byte[] endFinalBoundary = ArtifactSetReaderInputStream.toASCII("--\r\n");
    private static final byte[] jsonTypeHeader = ArtifactSetReaderInputStream.toASCII("Content-Type: application/json; charset=UTF-8\r\n");
    private static final byte[] octetsTypeHeader = ArtifactSetReaderInputStream.toASCII("Content-Type: application/octet-stream\r\n");
    private final ArtifactSetReader reader;
    private CodestationInputStream in;
    private boolean closed;
    private boolean finished;
    private byte[] boundary;
    private byte[] buf;
    private byte[] one;
    private int pos;
    private int end;
    private boolean reading;

    private static synchronized byte[] newBoundary() {
        byte[] b = new byte[32];
        for (int i = 0; i < b.length; ++i) {
            b[i] = boundaryAlphabet[rand.nextInt(boundaryAlphabet.length)];
        }
        return b;
    }

    private static byte[] toASCII(String s) {
        byte[] a = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("Non-ASCII character: " + c);
            }
            a[i] = (byte)c;
        }
        return a;
    }

    public ArtifactSetReaderInputStream(ArtifactSetReader reader) {
        this.reader = reader;
    }

    public String getBoundary() {
        this.initBoundary();
        char[] cs = new char[this.boundary.length];
        for (int i = 0; i < this.boundary.length; ++i) {
            cs[i] = (char)(this.boundary[i] & 0xFF);
        }
        return new String(cs);
    }

    @Override
    public int read() throws IOException {
        byte[] localOne = this.getOne();
        int n = this.read(localOne, 0, 1);
        if (n < 0) {
            return -1;
        }
        return localOne[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.startRead();
        try {
            int n;
            while (true) {
                if ((n = this.readBuffer(b, off, len)) > 0) {
                    int n2 = n;
                    return n2;
                }
                ArtifactSetReaderInputStream artifactSetReaderInputStream = this;
                // MONITORENTER : artifactSetReaderInputStream
                CodestationInputStream localIn = this.in;
                // MONITOREXIT : artifactSetReaderInputStream
                if (localIn == null) {
                    localIn = this.reader.read();
                    artifactSetReaderInputStream = this;
                    // MONITORENTER : artifactSetReaderInputStream
                    if (localIn == null) {
                        if (this.finished) {
                            int n3 = -1;
                            // MONITOREXIT : artifactSetReaderInputStream
                            return n3;
                        }
                        this.finish();
                        // MONITOREXIT : artifactSetReaderInputStream
                        continue;
                    }
                    this.in = localIn;
                    FileMetadata m = localIn.getMeta();
                    byte[] meta = m.toJSON().toString().getBytes(IO.utf8());
                    this.startPart(jsonTypeHeader);
                    this.buffer(meta);
                    this.startPart(octetsTypeHeader);
                    // MONITOREXIT : artifactSetReaderInputStream
                    continue;
                }
                n = localIn.read(b, off, len);
                if (n >= 0) break;
                artifactSetReaderInputStream = this;
                // MONITORENTER : artifactSetReaderInputStream
                this.in = null;
                // MONITOREXIT : artifactSetReaderInputStream
                localIn.close();
            }
            int n4 = n;
            return n4;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CodestationInputStream localIn = null;
        boolean doClose = false;
        ArtifactSetReaderInputStream artifactSetReaderInputStream = this;
        synchronized (artifactSetReaderInputStream) {
            if (!this.closed) {
                this.closed = true;
                doClose = true;
                localIn = this.in;
            }
            this.notifyAll();
        }
        if (doClose) {
            try {
                if (localIn != null) {
                    ((InputStream)localIn).close();
                }
            }
            finally {
                this.reader.close();
            }
        }
    }

    private synchronized void startRead() throws IOException {
        this.checkClosed();
        this.initBuffer();
        while (this.reading && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted", e);
            }
        }
        this.checkClosed();
        this.reading = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRead() {
        ArtifactSetReaderInputStream artifactSetReaderInputStream = this;
        synchronized (artifactSetReaderInputStream) {
            this.reading = false;
            this.notify();
        }
    }

    private synchronized int readBuffer(byte[] b, int off, int len) {
        if (this.pos >= this.end) {
            this.pos = 0;
            this.end = 0;
            return 0;
        }
        int n = Math.min(this.end - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    private void initBoundary() {
        if (this.boundary == null) {
            this.boundary = ArtifactSetReaderInputStream.newBoundary();
        }
    }

    private synchronized byte[] getOne() {
        if (this.one == null) {
            this.one = new byte[1];
        }
        return this.one;
    }

    private void buffer(byte[] bytes) {
        if (this.pos > 0) {
            throw new RuntimeException("buffer not empty");
        }
        if (this.buf.length - this.end < bytes.length) {
            byte[] t = new byte[this.end + bytes.length];
            System.arraycopy(this.buf, 0, t, 0, this.end);
            this.buf = t;
        }
        System.arraycopy(bytes, 0, this.buf, this.end, bytes.length);
        this.end += bytes.length;
    }

    private void finish() throws IOException {
        this.initBoundary();
        this.buffer(startBoundary);
        this.buffer(this.boundary);
        this.buffer(endFinalBoundary);
        this.finished = true;
    }

    private void initBuffer() {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
    }

    private void startPart(byte[] typeHeader) {
        this.initBoundary();
        this.buffer(startBoundary);
        this.buffer(this.boundary);
        this.buffer(crlf);
        this.buffer(typeHeader);
        this.buffer(encodingHeader);
        this.buffer(crlf);
    }

    private synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
    }
}

