/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.asm.AsmConnector;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class AsmConnectorCaching
implements AsmConnector {
    private final AsmConnector conn;
    private final int maxSize;
    private final long ttlPositive;
    private final long ttlNegative;
    private final Map<UUID, CacheEntry> cache;

    public AsmConnectorCaching(int maxSize, long ttlPositive, long ttlNegative, AsmConnector conn) {
        if (maxSize < 0) {
            maxSize = 0;
        }
        if (ttlPositive < 0L) {
            ttlPositive = 0L;
        }
        if (ttlNegative < 0L) {
            ttlNegative = 0L;
        }
        this.conn = conn;
        this.maxSize = maxSize;
        this.ttlPositive = ttlPositive;
        this.ttlNegative = ttlNegative;
        this.cache = this.createCache();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.conn + "]";
    }

    @Override
    public UUID getBlobId(UUID localId, UUID artifactSetId) throws IOException {
        CacheEntry e = this.getCached(artifactSetId);
        if (e != null) {
            return e.bid;
        }
        UUID blobId = this.conn.getBlobId(localId, artifactSetId);
        this.cache(artifactSetId, blobId);
        return blobId;
    }

    @Override
    public IDMappingReader getMappingReader(UUID localId) throws IOException {
        return this.conn.getMappingReader(localId);
    }

    @Override
    public void start() {
        this.conn.start();
    }

    @Override
    public void stop() {
        this.conn.stop();
    }

    private Map<UUID, CacheEntry> createCache() {
        if (this.maxSize <= 0) {
            return null;
        }
        float load = 0.75f;
        int cap = 1 + (int)((float)this.maxSize / load);
        return new LinkedHashMap<UUID, CacheEntry>(cap, load, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<UUID, CacheEntry> eldest) {
                return this.size() > AsmConnectorCaching.this.maxSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCached(UUID asid) {
        if (this.maxSize <= 0) {
            return null;
        }
        Map<UUID, CacheEntry> map = this.cache;
        synchronized (map) {
            CacheEntry e = this.cache.get(asid);
            if (e == null) {
                return null;
            }
            if (!e.isValid()) {
                this.cache.remove(asid);
                return null;
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(UUID asid, UUID bid) {
        if (this.maxSize <= 0) {
            return;
        }
        if (bid != null && this.ttlPositive <= 0L) {
            return;
        }
        if (bid == null && this.ttlNegative <= 0L) {
            return;
        }
        Map<UUID, CacheEntry> map = this.cache;
        synchronized (map) {
            CacheEntry fresh = new CacheEntry(bid);
            CacheEntry old = this.cache.get(asid);
            if (old == null || old.stamp < fresh.stamp) {
                this.cache.put(asid, fresh);
            }
        }
    }

    class CacheEntry {
        final UUID bid;
        final long stamp;

        CacheEntry(UUID bid) {
            this.bid = bid;
            this.stamp = System.currentTimeMillis();
        }

        boolean isValid() {
            long now = System.currentTimeMillis();
            long ttl = AsmConnectorCaching.this.ttlPositive;
            if (this.bid == null) {
                ttl = AsmConnectorCaching.this.ttlNegative;
            }
            return now - this.stamp <= ttl;
        }
    }
}

