/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobMetadata;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class BlobMetadataList
extends AbstractList<BlobMetadata>
implements RandomAccess {
    static final int WIDTH = 4;
    private long[] array;
    private int size;

    public BlobMetadataList() {
        this.array = new long[64];
    }

    public BlobMetadataList(Collection<BlobMetadata> c) {
        if (c instanceof BlobMetadataList) {
            BlobMetadataList bml = (BlobMetadataList)c;
            int rawSize = bml.size * 4;
            this.array = Arrays.copyOf(bml.array, rawSize);
            this.size = bml.size;
        } else if (c instanceof SubList) {
            SubList sl = (SubList)c;
            int from = sl.offset * 4;
            int to = from + sl.size * 4;
            this.array = Arrays.copyOfRange(sl.parent().array, from, to);
            this.size = sl.size;
        } else {
            this.array = new long[c.size() * 4];
            this.addAll(c);
        }
    }

    @Override
    public BlobMetadata get(int index) {
        try {
            return this.get0(index * 4);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.outOfBounds(index, e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BlobMetadata set(int index, BlobMetadata element) {
        if (element == null) {
            throw new NullPointerException();
        }
        try {
            int i = index * 4;
            BlobMetadata old = this.get0(i);
            this.set0(i, element);
            return old;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.outOfBounds(index, e);
        }
    }

    @Override
    public void add(int index, BlobMetadata element) {
        if (element == null) {
            throw new NullPointerException();
        }
        try {
            if (index > this.size) {
                throw this.outOfBounds(index, null);
            }
            this.ensureCapacity(this.size + 1);
            int i = index * 4;
            this.insertSlot(i);
            this.set0(i, element);
            ++this.modCount;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.outOfBounds(index, e);
        }
    }

    @Override
    public BlobMetadata remove(int index) {
        try {
            if (index >= this.size) {
                throw this.outOfBounds(index, null);
            }
            int i = index * 4;
            BlobMetadata old = this.get0(i);
            this.removeSlot(i);
            ++this.modCount;
            return old;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.outOfBounds(index, e);
        }
    }

    @Override
    public List<BlobMetadata> subList(int fromIndex, int toIndex) {
        return new SubList(fromIndex, toIndex);
    }

    private BlobMetadata get0(int rawIndex) {
        long idMsb = this.array[rawIndex + 0];
        long idLsb = this.array[rawIndex + 1];
        long lastAccessed = this.array[rawIndex + 2];
        long size = this.array[rawIndex + 3];
        return new BlobMetadata(idMsb, idLsb, lastAccessed, size);
    }

    private void set0(int rawIndex, BlobMetadata lm) {
        this.array[rawIndex + 0] = lm.getIdMsb();
        this.array[rawIndex + 1] = lm.getIdLsb();
        this.array[rawIndex + 2] = lm.getLastAccessed();
        this.array[rawIndex + 3] = lm.getLength();
    }

    private void ensureCapacity(int neededSize) {
        if (neededSize > 0x1FFFFFFF) {
            throw new IllegalArgumentException("list too long: " + this.size);
        }
        int rawNeededSize = 4 * neededSize;
        if (rawNeededSize > this.array.length) {
            int len = Math.max(rawNeededSize, 3 * this.array.length / 2);
            long[] t = new long[len];
            System.arraycopy(this.array, 0, t, 0, this.array.length);
            this.array = t;
        }
    }

    private void insertSlot(int rawIndex) {
        System.arraycopy(this.array, rawIndex, this.array, rawIndex + 4, 4 * this.size - rawIndex);
        ++this.size;
    }

    private void removeSlot(int rawIndex) {
        System.arraycopy(this.array, rawIndex + 4, this.array, rawIndex, 4 * this.size - rawIndex - 4);
        --this.size;
    }

    private IndexOutOfBoundsException outOfBounds(int index, ArrayIndexOutOfBoundsException e) {
        IndexOutOfBoundsException r = new IndexOutOfBoundsException("index: " + index);
        if (e != null) {
            r.initCause(e);
        }
        return r;
    }

    private class SubList
    extends AbstractList<BlobMetadata>
    implements RandomAccess {
        private int offset;
        private int size;

        SubList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
            }
            if (toIndex > this.parent().size()) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
            }
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public BlobMetadata get(int index) {
            return this.parent().get(this.offset + index);
        }

        @Override
        public BlobMetadata set(int index, BlobMetadata element) {
            return this.parent().set(this.offset + index, element);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(int index, BlobMetadata element) {
            this.parent().add(this.offset + index, element);
            ++this.size;
        }

        @Override
        public BlobMetadata remove(int index) {
            BlobMetadata old = this.parent().remove(this.offset + index);
            --this.size;
            return old;
        }

        @Override
        public List<BlobMetadata> subList(int fromIndex, int toIndex) {
            return new SubList(this.offset + fromIndex, this.offset + toIndex);
        }

        BlobMetadataList parent() {
            return BlobMetadataList.this;
        }
    }
}

