/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobSource;
import java.io.IOException;
import java.io.InputStream;

class BlobSourceWaiter
implements BlobSource {
    private static final int GETTING = 0;
    private static final int SUCCESS = 1;
    private static final int FAILURE = 2;
    private final BlobSource src;
    private int state;

    BlobSourceWaiter(BlobSource src) {
        this.src = src;
    }

    @Override
    public InputStream get() throws IOException {
        return this.src.get();
    }

    synchronized void setGetSuccess(boolean success) {
        if (this.state != 0) {
            throw new IllegalStateException("Not getting: " + this.state);
        }
        this.state = success ? 1 : 2;
        this.notifyAll();
    }

    synchronized boolean await() {
        try {
            while (this.state == 0) {
                this.wait();
            }
            return this.state == 1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }
}

