/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore.pruner;

import com.ibm.uclab.csrepl.blobstore.BlobMetadata;
import com.ibm.uclab.csrepl.blobstore.BlobMetadataList;
import com.ibm.uclab.csrepl.blobstore.BlobStore;
import com.ibm.uclab.csrepl.blobstore.pruner.Limiter;
import com.ibm.uclab.csrepl.blobstore.pruner.PruneResult;
import com.ibm.uclab.csrepl.blobstore.pruner.Pruner;
import java.io.IOException;

public class PrunerImpl
implements Pruner {
    private final long maxSize;

    public PrunerImpl(long maxSize) {
        this.maxSize = maxSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[maxSize=" + this.maxSize + "]";
    }

    @Override
    public PruneResult prune(BlobStore store) throws IOException {
        if (this.maxSize < 0L) {
            return new PruneResult(0L, 0L);
        }
        BlobMetadataList meta = new BlobMetadataList();
        for (BlobMetadata m : store.getAllBlobMeta()) {
            meta.add(m);
            if (!Thread.currentThread().isInterrupted()) continue;
            return new PruneResult(0L, 0L);
        }
        Limiter limiter = new Limiter(meta, this.maxSize);
        BlobMetadataList toRemove = limiter.getToRemove();
        toRemove = new BlobMetadataList(toRemove);
        long blobsPruned = 0L;
        long bytesPruned = 0L;
        for (BlobMetadata m : toRemove) {
            if (store.pruneBlob(m.getId(), m.getLastAccessed())) {
                ++blobsPruned;
                ++bytesPruned;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
        return new PruneResult(blobsPruned, bytesPruned);
    }
}

