/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client;

import com.ibm.uclab.csrepl.client.ArtifactSetBuilderClientData;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class ArtifactSetReaderImpl
implements ArtifactSetReader {
    private CloseNotifier current;
    private boolean closed;

    ArtifactSetReaderImpl(ArtifactSetBuilderClientData dummy) {
    }

    @Override
    public synchronized CodestationInputStream read() throws IOException {
        try {
            if (this.current != null && this.current.active) {
                throw new IllegalStateException("Previous stream not closed");
            }
            if (this.closed) {
                return null;
            }
            while (this.current == null && !this.closed) {
                this.wait();
            }
            if (this.closed) {
                return null;
            }
            this.current.active = true;
            return new CodestationInputStream(this.current, this.current.meta);
        }
        catch (InterruptedException e) {
            this.closed = true;
            return null;
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void add(InputStream data, FileMetadata meta) throws IOException {
        if (meta == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            data = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this.closed) {
                data.close();
                return;
            }
            while (this.current != null && !this.closed) {
                this.wait();
            }
            if (this.closed) {
                data.close();
                return;
            }
            this.current = new CloseNotifier(data, meta);
            this.notifyAll();
            while (this.current != null && !this.closed) {
                this.wait();
            }
            if (this.closed) {
                if (this.current != null) {
                    this.current.close();
                }
                return;
            }
        }
        catch (InterruptedException e) {
            try {
                this.close();
                if (this.current != null) {
                    this.current.close();
                }
            }
            finally {
                data.close();
            }
        }
    }

    private class CloseNotifier
    extends FilterInputStream {
        final FileMetadata meta;
        boolean active;

        CloseNotifier(InputStream data, FileMetadata meta) {
            super(data);
            data.getClass();
            meta.getClass();
            this.meta = meta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                ArtifactSetReaderImpl artifactSetReaderImpl = ArtifactSetReaderImpl.this;
                synchronized (artifactSetReaderImpl) {
                    if (ArtifactSetReaderImpl.this.current == this) {
                        ArtifactSetReaderImpl.this.current = null;
                        this.active = false;
                        ArtifactSetReaderImpl.this.notifyAll();
                    }
                }
            }
        }
    }
}

