/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.ibm.uclab.csrepl.codestation.StreamFactoryArtifactSet;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateReader;
import com.urbancode.codestation2.common.aggregate.PathFilter;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class ArtifactSetReaderImpl
implements ArtifactSetReader {
    protected final ArtifactSetManager artifactSetManager;
    protected final BlobManager blobManager;
    protected final UUID artifactSetId;
    protected final PathFilter filter;
    protected AggregateReader reader;
    private boolean closed;

    protected ArtifactSetReaderImpl(ArtifactSetManager artifactSetManager, BlobManager blobManager, UUID artifactSetId, Filter filter) throws IOException {
        this.artifactSetManager = artifactSetManager;
        this.artifactSetManager.getClass();
        this.blobManager = blobManager;
        this.blobManager.getClass();
        this.artifactSetId = artifactSetId;
        this.artifactSetId.getClass();
        if (filter == null) {
            this.filter = null;
        } else {
            PathFilter pf = filter.toPathFilter();
            if (pf.isAcceptAll()) {
                pf = null;
            }
            this.filter = pf;
        }
        this.initReader();
    }

    @Override
    public CodestationInputStream read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        this.initReader();
        AggregateInputStream in = this.reader.read();
        if (in == null) {
            return null;
        }
        return new CodestationInputStream((InputStream)in, new FileMetadata(in.getItem()));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    protected void initReader() throws IOException {
        if (this.reader == null) {
            StreamFactoryArtifactSet factory = new StreamFactoryArtifactSet(this.artifactSetManager, this.blobManager, this.artifactSetId);
            Aggregate aggr = Aggregate.createReadOnlyStreaming((StreamFactory)factory);
            this.reader = aggr.openReader(this.filter);
        }
    }
}

