/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.MultipartStream;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class ArtifactSetReaderMultipart
implements ArtifactSetReader {
    private static final Logger log = Logger.getLogger(ArtifactSetReaderMultipart.class);
    private final MultipartStream stream;
    private final InputStream in;
    private boolean started;
    private boolean ended;
    private boolean hasNext;

    ArtifactSetReaderMultipart(InputStream in, String boundary) {
        byte[] bnd = this.toASCII(boundary);
        this.in = in;
        this.in.getClass();
        this.stream = new MultipartStream(in, bnd, 4096);
    }

    @Override
    public CodestationInputStream read() throws IOException {
        if (this.ended) {
            return null;
        }
        if (!this.started) {
            this.started = true;
            this.hasNext = this.stream.skipPreamble();
        } else {
            this.hasNext = this.stream.readBoundary();
        }
        if (!this.hasNext) {
            this.ended = true;
            this.skipPostamble();
            return null;
        }
        FileMetadata meta = this.readMeta();
        InputStream data = this.readData();
        return new CodestationInputStream(data, meta);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private FileMetadata readMeta() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.stream.readHeaders();
        this.stream.readBodyData(out, 65536);
        this.hasNext = this.stream.readBoundary();
        String json = new String(out.toByteArray(), IO.utf8());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Metadata JSON: " + json));
        }
        if (!this.hasNext) {
            throw new IOException("Missing data section");
        }
        try {
            return FileMetadata.fromJSON(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new IOException("Invalid metadata JSON", e);
        }
    }

    private InputStream readData() throws IOException {
        this.stream.readHeaders();
        return this.stream.getBodyData();
    }

    private byte[] toASCII(String s) {
        byte[] a = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("Non-ASCII character: " + c);
            }
            a[i] = (byte)c;
        }
        return a;
    }

    private void skipPostamble() throws IOException {
        IO.discard((InputStream)this.in);
    }
}

