/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.ParseException;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class GeoTagListParser {
    private static final String DIGITS = "0123456789abcdef";
    private int pos;
    private String original;
    private String value;
    private Set<String> geoTags;

    public static String escapeTag(String s) {
        int i;
        int c;
        int end;
        byte[] b = s.getBytes(IO.utf8());
        StringBuilder sb = new StringBuilder();
        for (end = 0; end < b.length && (c = b[end] & 0xFF) == 32; ++end) {
            sb.append("%20");
        }
        int start = end;
        while (end < b.length) {
            c = b[end] & 0xFF;
            if (c == 32) {
                ++end;
                continue;
            }
            for (i = start; i < end; ++i) {
                sb.append(" ");
            }
            if (c < 32 || c >= 127 || c == 37 || c == 44) {
                sb.append('%');
                sb.append(DIGITS.charAt(c >>> 4));
                sb.append(DIGITS.charAt(c & 0xF));
            } else {
                sb.append((char)c);
            }
            start = ++end;
        }
        for (i = start; i < end; ++i) {
            sb.append("%20");
        }
        return sb.toString();
    }

    public GeoTagListParser(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
        this.original = value;
    }

    public Set<String> getGeoTags() {
        this.parse();
        return Collections.unmodifiableSet(this.geoTags);
    }

    void parse() {
        if (this.geoTags != null) {
            return;
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.value.length() == 0) {
            this.geoTags = tags;
            return;
        }
        String[] array = this.split(this.value);
        if (array.length == 0) {
            this.geoTags = tags;
            return;
        }
        if (array.length == 1 && array[0].trim().length() == 0) {
            this.geoTags = tags;
            return;
        }
        for (String s : array) {
            if ((s = s.trim()).length() == 0) {
                throw new ParseException(this.pos, "Invalid geo tag list", this.original);
            }
            tags.add(this.unescape(s));
        }
        this.geoTags = tags;
    }

    String unescape(String s) {
        ByteArrayOutputStream out = null;
        int start = 0;
        int end = 0;
        while (end < s.length()) {
            char c = s.charAt(end);
            if (c == '%') {
                if (s.length() - end < 3) {
                    throw new ParseException("Invalid hex escape");
                }
                int h1 = this.parseHex(s.charAt(end + 1));
                int h2 = this.parseHex(s.charAt(end + 2));
                if (h1 == -1 || h2 == -1) {
                    throw new ParseException("Invalid hex escape");
                }
                c = (char)(h1 * 16 + h2);
                if (out == null) {
                    out = new ByteArrayOutputStream();
                }
                for (int i = start; i < end; ++i) {
                    out.write(s.charAt(i));
                }
                out.write(c);
                start = end += 3;
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                throw new ParseException("Unescaped character");
            }
            ++end;
        }
        if (out == null) {
            return s;
        }
        for (int i = start; i < end; ++i) {
            out.write(s.charAt(i));
        }
        ByteBuffer buf = ByteBuffer.wrap(out.toByteArray());
        CharsetDecoder dec = IO.utf8().newDecoder();
        try {
            return dec.decode(buf).toString();
        }
        catch (CharacterCodingException e) {
            throw new ParseException("Invalid UTF-8 sequence");
        }
    }

    private String[] split(String s) {
        int i;
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        while (start < s.length() && (i = s.indexOf(44, start)) != -1) {
            parts.add(s.substring(start, i));
            start = i + 1;
        }
        parts.add(s.substring(start));
        return parts.toArray(new String[parts.size()]);
    }

    private int parseHex(char c) {
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return -1;
    }
}

