/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.GeoTagListParser;
import com.ibm.uclab.csrepl.ptrstore.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class IDMappingParser {
    private int pos;
    private String original;
    private String mapping;
    private UUID artifactSetId;
    private UUID blobId;
    private Set<String> geoTags;
    private Map<String, String> extraProperties;

    public static String escapePropVal(String s) {
        if (s.startsWith(" ") || s.endsWith(" ")) {
            throw new IllegalArgumentException("Invalid value: " + s);
        }
        StringBuilder sb = null;
        int start = 0;
        int end = 0;
        while (end < s.length()) {
            char c = s.charAt(end);
            if (c < ' ' || c >= '\u007f') {
                throw new IllegalArgumentException("Invalid value: " + s);
            }
            if (c == '\\' || c == ';' || c == ':') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(s, start, end);
                sb.append("\\");
                sb.append(c);
                start = ++end;
                continue;
            }
            ++end;
        }
        if (sb == null) {
            return s;
        }
        sb.append(s, start, end);
        return sb.toString();
    }

    static boolean isNameStartChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c == '_' || c == '-';
    }

    static boolean isNameChar(char c) {
        if (IDMappingParser.isNameStartChar(c)) {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    static boolean isValueChar(char c) {
        return c >= ' ' && c < '\u007f';
    }

    IDMappingParser(String mapping) {
        if (mapping == null) {
            throw new NullPointerException("mapping");
        }
        this.mapping = mapping;
        this.original = mapping;
    }

    UUID getArtifactSetId() {
        this.parse();
        return this.artifactSetId;
    }

    UUID getBlobId() {
        this.parse();
        return this.blobId;
    }

    Set<String> getGeoTags() {
        this.parse();
        return this.geoTags;
    }

    Map<String, String> getExtraProperties() {
        this.parse();
        return this.extraProperties;
    }

    void parse() {
        if (this.mapping == null) {
            return;
        }
        Set<Object> tags = new LinkedHashSet();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        UUID asid = this.parseUUID();
        this.parseChar('=');
        UUID bid = this.parseUUID();
        while (this.parseCharOpt(';')) {
            String name = this.parsePropName(props.keySet());
            this.parseChar(':');
            String value = this.parsePropValue();
            props.put(name, value);
        }
        this.parseEndOfLine();
        String tagsValue = (String)props.remove("geo");
        if (tagsValue != null) {
            tags = new GeoTagListParser(tagsValue).getGeoTags();
        }
        this.mapping = null;
        this.original = null;
        this.artifactSetId = asid;
        this.blobId = bid;
        this.geoTags = tags;
        this.extraProperties = props;
    }

    private UUID parseUUID() {
        try {
            this.discardWhitespace();
            if (this.mapping.length() < 36) {
                throw new ParseException(this.pos, "Line too short", this.original);
            }
            UUID u = UUID.fromString(this.mapping.substring(0, 36));
            this.mapping = this.mapping.substring(36);
            this.pos += 36;
            return u;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(this.pos, "Invalid UUID", this.original);
        }
    }

    private void parseChar(char c) {
        this.discardWhitespace();
        if (this.mapping.length() == 0 || this.mapping.charAt(0) != c) {
            throw new ParseException(this.pos, "Expected '" + c + "'", this.original);
        }
        this.mapping = this.mapping.substring(1);
        ++this.pos;
    }

    private boolean parseCharOpt(char c) {
        this.discardWhitespace();
        if (this.mapping.length() == 0 || this.mapping.charAt(0) != c) {
            return false;
        }
        this.mapping = this.mapping.substring(1);
        ++this.pos;
        return true;
    }

    private String parsePropName(Set<String> existingProps) {
        this.discardWhitespace();
        int end = 0;
        if (this.mapping.length() == 0 || !IDMappingParser.isNameStartChar(this.mapping.charAt(end))) {
            throw new ParseException(this.pos, "Expected property start", this.original);
        }
        ++end;
        while (end < this.mapping.length() && IDMappingParser.isNameChar(this.mapping.charAt(end))) {
            ++end;
        }
        String name = this.mapping.substring(0, end);
        if (existingProps.contains(name)) {
            throw new ParseException(this.pos, "Duplicate property", this.original);
        }
        this.mapping = this.mapping.substring(end);
        this.pos += end;
        return name;
    }

    private String parsePropValue() {
        int end;
        this.discardWhitespace();
        StringBuilder sb = new StringBuilder();
        for (end = 0; end < this.mapping.length() && this.mapping.charAt(end) != ';'; ++end) {
            char c = this.mapping.charAt(end);
            if (c == ':') {
                throw new ParseException(this.pos + end, "Invalid character", this.original);
            }
            if (c == '\\') {
                if (++end >= this.mapping.length()) {
                    throw new ParseException(this.pos + end, "Expected escaped character", this.original);
                }
                c = this.mapping.charAt(end);
                if (c != '\\' && c != ';' && c != ':') {
                    throw new ParseException(this.pos + end - 1, "Invalid escape sequence", this.original);
                }
            }
            if (!IDMappingParser.isValueChar(c)) {
                throw new ParseException(this.pos + end, "Invalid value character", this.original);
            }
            sb.append(c);
        }
        this.mapping = this.mapping.substring(end);
        this.pos += end;
        return sb.toString().trim();
    }

    private void parseEndOfLine() {
        this.discardWhitespace();
        if (this.mapping.length() != 0) {
            throw new ParseException(this.pos, "Expected end-of-line", this.original);
        }
    }

    private void discardWhitespace() {
        int end;
        for (end = 0; end < this.mapping.length() && this.mapping.charAt(end) == ' '; ++end) {
        }
        this.mapping = this.mapping.substring(end);
        this.pos += end;
    }
}

