/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class HashInjectingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final MessageDigest dig;
    private boolean closed;

    public HashInjectingOutputStream(OutputStream out, MessageDigest dig) {
        this.out = out;
        this.dig = dig;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.dig.update((byte)b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.dig.update(b, off, len);
    }

    public synchronized void abort() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.out.close();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            byte[] hash = this.dig.digest();
            this.out.write(hash);
            this.out.close();
        }
    }
}

