/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SubRangeInputStream
extends InputStream {
    private final long maxLength;
    private final long offset;
    private final InputStream in;
    private long position;

    public SubRangeInputStream(InputStream in, long offset, long maxLength) {
        this.offset = offset;
        this.maxLength = maxLength;
        this.in = in;
        this.position = -1L;
    }

    @Override
    public synchronized int read() throws IOException {
        this.initPosition();
        int b = this.in.read();
        if (this.remaining() <= 0L) {
            return -1;
        }
        if (b != -1) {
            ++this.position;
        }
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.initPosition();
        if (this.remaining() <= 0L) {
            return -1;
        }
        int n = (int)Math.min(this.remaining(), (long)len);
        int r = this.in.read(b, off, n);
        if (r != -1) {
            this.position += (long)r;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private long remaining() {
        return this.maxLength - this.position;
    }

    private void initPosition() throws IOException {
        if (this.position == -1L) {
            if (this.in instanceof SeekableInputStream) {
                ((SeekableInputStream)this.in).seek(this.offset);
            } else {
                this.in.skip(this.offset);
            }
            this.position = 0L;
        }
    }
}

