/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.logging;

import com.urbancode.commons.util.Check;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4jOutputStream
extends OutputStream {
    private Logger logger;
    private final Level level;
    private final int lineLimit;
    private StringBuilder sb = new StringBuilder();

    public Log4jOutputStream(Logger logger, Level level, int lineLimit) {
        Check.nonNull(logger, "Logger");
        this.logger = logger;
        this.level = level;
        this.lineLimit = lineLimit;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.logger == null) {
            throw new IOException("Log4jOutputStream is closed.");
        }
        char c = (char)b;
        if (c == '\n' || c == '\r') {
            this.flush();
        } else {
            this.sb.append(c);
            if (this.lineLimit > 0 && this.sb.length() >= this.lineLimit) {
                this.flush();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.sb.length() > 0) {
            this.logger.log(this.level, this.sb.toString());
            this.sb = new StringBuilder();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.logger = null;
    }
}

