/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import com.urbancode.codestation2.common.aggregate.AggregateReader;
import com.urbancode.codestation2.common.aggregate.AggregateReaderFactory;
import com.urbancode.codestation2.common.aggregate.AggregateReaderImpl;
import com.urbancode.codestation2.common.aggregate.AggregateWriter;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import com.urbancode.codestation2.common.aggregate.ItemTableFiltered;
import com.urbancode.codestation2.common.aggregate.ItemTableRO;
import com.urbancode.codestation2.common.aggregate.ItemTableRW;
import com.urbancode.codestation2.common.aggregate.PathFilter;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Aggregate {
    public static final String FILE_TABLE_NAME = ".urbancode-file-table";
    public static final String ZERO_FILE_NAME = ".urbancode-zero";
    public static final int FILE = 1;
    public static final int DIR = 2;
    public static final int SYMLINK = 3;
    public static final int META_ONLY_FLAG = Integer.MIN_VALUE;
    private File permDir;
    private File tempDir;
    private File tableFile;
    private AggregateWriter writer;
    private StreamFactory streamFactory;
    private AggregateReaderFactory readerFactory;

    public static Aggregate createReadOnly(File permDir) {
        if (permDir == null) {
            throw new NullPointerException("permDir");
        }
        File tempDir = null;
        StreamFactory streamFactory = null;
        return new Aggregate(permDir, tempDir, streamFactory);
    }

    public static Aggregate createReadWrite(File permDir, File tempDir) {
        if (permDir == null) {
            throw new NullPointerException("permDir");
        }
        if (tempDir == null) {
            throw new NullPointerException("tempDir");
        }
        StreamFactory streamFactory = null;
        return new Aggregate(permDir, tempDir, streamFactory);
    }

    public static Aggregate createReadOnlyStreaming(StreamFactory streamFactory) {
        File permDir = null;
        File tempDir = null;
        return new Aggregate(permDir, tempDir, streamFactory);
    }

    public static Aggregate createReadOnlyStreaming(StreamFactory streamFactory, AggregateReaderFactory readerFactory) {
        File permDir = null;
        File tempDir = null;
        return new Aggregate(permDir, tempDir, streamFactory, readerFactory);
    }

    public static String typeToString(int type) {
        String result;
        int t = type;
        switch (t &= Integer.MAX_VALUE) {
            case 2: {
                result = "dir";
                break;
            }
            case 1: {
                result = "file";
                break;
            }
            case 3: {
                result = "symlink";
                break;
            }
            default: {
                result = "<unknown>";
            }
        }
        if ((type & Integer.MIN_VALUE) != 0) {
            result = result + " [meta-only]";
        }
        return result;
    }

    public static boolean isSpecialDataFile(String name) {
        return name.startsWith(".urbancode-");
    }

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String sanitizePath(String path) {
        if (Aggregate.isPathSanitized(path)) {
            return path;
        }
        int len = path.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                int j = Aggregate.skipSlashes(path, i);
                if (i > 0 && j < len) {
                    sb.append('/');
                }
                i = j;
                continue;
            }
            sb.append(c);
            ++i;
        }
        path = sb.toString();
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path empty");
        }
        return path;
    }

    private static int skipSlashes(String path, int i) {
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static boolean isPathSanitized(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        int end = path.length() - 1;
        boolean sawSlash = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                return false;
            }
            if (c != '/') {
                sawSlash = false;
                continue;
            }
            if (c != '/') continue;
            if (sawSlash) {
                return false;
            }
            if (i == 0 || i == end) {
                return false;
            }
            sawSlash = true;
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path empty");
        }
        return true;
    }

    public static boolean isPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        if (!Aggregate.isPathSanitized(path)) {
            return false;
        }
        return !path.startsWith("../") && !path.endsWith("/..") && !path.startsWith("./") && !path.endsWith("/.") && !path.contains("/../") && !path.contains("/./") && !path.equals("..") && !path.equals(".");
    }

    static String unsafeSanitize(String path) {
        String prev = null;
        while (!Aggregate.isPathValid(path)) {
            if (path == null) {
                return "file-" + UUID.randomUUID();
            }
            if (path.equals(prev)) {
                return "file-" + UUID.randomUUID();
            }
            path = path.replaceAll("^\\.\\./", "");
            path = path.replaceAll("^\\./", "");
            path = path.replaceAll("/\\.\\.$", "");
            path = path.replaceAll("/\\.$", "");
            path = path.replaceAll("/\\./", "/");
            path = path.replaceAll("/\\.\\./", "/");
            path = path.replaceAll("/+", "/");
            path = path.replaceAll("^/", "");
            if ((path = path.replaceAll("/$", "")).equals("..")) {
                return "file-" + UUID.randomUUID();
            }
            if (path.equals(".")) {
                return "file-" + UUID.randomUUID();
            }
            if (path.length() == 0) {
                return "file-" + UUID.randomUUID();
            }
            prev = path;
            path = Aggregate.sanitizePath(path);
        }
        return path;
    }

    public Aggregate(File permDir, File tempDir) {
        this(permDir, tempDir, null);
    }

    public Aggregate(File permDir, File tempDir, StreamFactory streamFactory) {
        this(permDir, tempDir, streamFactory, null);
    }

    public Aggregate(File permDir, File tempDir, StreamFactory streamFactory, AggregateReaderFactory readerFactory) {
        if (permDir != null) {
            permDir = permDir.getAbsoluteFile();
        }
        if (tempDir != null) {
            tempDir = tempDir.getAbsoluteFile();
        }
        this.permDir = permDir;
        this.tempDir = tempDir;
        this.streamFactory = streamFactory;
        if (permDir != null) {
            this.tableFile = new File(permDir, FILE_TABLE_NAME);
        }
        this.readerFactory = readerFactory == null ? new AggregateReaderFactory(){

            @Override
            public AggregateReader openReader(ItemTable table) throws IOException {
                return new AggregateReaderImpl(Aggregate.this.permDir, table, Aggregate.this.streamFactory);
            }
        } : readerFactory;
    }

    public File getTableFile() {
        return this.tableFile;
    }

    public List<File> getDataFiles() throws IOException {
        if (this.permDir == null) {
            return new ArrayList<File>();
        }
        HashSet<String> names = new HashSet<String>();
        ItemTableRW table = this.readTable();
        for (AggregateItem item : table) {
            names.add(item.getDataFileName());
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String name : names) {
            File f = new File(this.permDir, name);
            if (!f.isFile()) continue;
            files.add(f);
        }
        return files;
    }

    public void renameDataFiles(Map<String, String> renaming) throws IOException {
        AggregateWriter writer = this.openWriter();
        try {
            writer.renameDataFiles(renaming);
        }
        finally {
            writer.close();
        }
    }

    public boolean exists() {
        boolean isFile;
        if (this.tableFile == null) {
            return false;
        }
        int timeout = 25;
        int tries = 0;
        while (!(isFile = this.tableFile.isFile()) && Aggregate.isWindows() && ++tries < 2) {
            Aggregate.sleep(timeout);
            timeout *= 2;
        }
        return isFile;
    }

    public File getPermDir() {
        return this.permDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public ItemTable getTable(PathFilter filter) throws IOException {
        if (filter == null) {
            return new ItemTableRO(this.readTable());
        }
        return new ItemTableFiltered(this.readTable(), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateInputStream read(String path) throws IOException {
        AggregateReader r = this.openReader(null);
        try {
            AggregateInputStream aggregateInputStream = r.read(path);
            return aggregateInputStream;
        }
        finally {
            r.close();
        }
    }

    public AggregateReader openReader(PathFilter filter) throws IOException {
        return this.readerFactory.openReader(this.getTable(filter));
    }

    public boolean isMetaOnly() throws IOException {
        return this.readTable().isMetaOnly();
    }

    public void setMetaOnly(boolean metaOnly) throws IOException {
        AggregateWriter w = this.openWriter();
        try {
            w.setMetaOnly(metaOnly);
            w.close();
        }
        finally {
            w.abort();
        }
    }

    public AggregateWriter openWriter() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("writer already open");
        }
        if (this.permDir == null) {
            throw new IllegalStateException("cannot write without a perm directory");
        }
        if (this.tempDir == null) {
            throw new IllegalStateException("cannot write without a temp directory");
        }
        assert (this.tableFile != null);
        ItemTableRW table = this.readTable();
        this.writer = new AggregateWriter(this, table, this.permDir, this.tempDir, this.tableFile);
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateItem write(AggregateItemMeta meta, InputStream in, MessageDigest dig) throws IOException {
        AggregateItem item;
        AggregateWriter w = this.openWriter();
        try {
            item = w.write(meta, in, dig);
            w.close();
        }
        finally {
            w.abort();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateItem delete(String path) throws IOException {
        AggregateItem item = null;
        AggregateWriter w = this.openWriter();
        try {
            item = w.delete(path);
            w.close();
        }
        finally {
            w.abort();
        }
        return item;
    }

    void writerClosed() {
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemTableRW readTable() throws IOException {
        if (this.tableFile == null && this.streamFactory == null) {
            throw new IOException("No perm directory or stream factory");
        }
        ItemTableRW table = new ItemTableRW();
        int timeout = 25;
        int tries = 0;
        while (true) {
            try {
                ++tries;
                if (this.tableFile == null) {
                    SeekableInputStream in = this.streamFactory.openInput(FILE_TABLE_NAME);
                    try {
                        table.read(in);
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
                table.read(this.tableFile);
            }
            catch (IOException e) {
                if (this.tableFile == null || !Aggregate.isWindows() || tries >= 5) {
                    throw e;
                }
                Aggregate.sleep(timeout);
                timeout *= 2;
                continue;
            }
            break;
        }
        return table;
    }
}

