/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.SharedFileReader;
import java.io.IOException;

class AggregateInputStreamSH
extends AggregateInputStream {
    private final AggregateItem item;
    private volatile SharedFileReader in;
    private long position;
    private long length;

    AggregateInputStreamSH(AggregateItem item, SharedFileReader in) throws IOException {
        this.item = item;
        this.in = in;
        this.position = item.getOffset();
        this.length = item.getLength();
        in.incref();
    }

    @Override
    public AggregateItem getItem() {
        return this.item;
    }

    @Override
    public synchronized int read() throws IOException {
        SharedFileReader i = this.in;
        if (i == null) {
            throw new IOException("stream closed");
        }
        if (this.length == 0L) {
            return -1;
        }
        int b = i.pread(this.position);
        if (b != -1) {
            --this.length;
            ++this.position;
        }
        if (b == -1) {
            this.close();
            if (this.length > 0L) {
                throw new IOException("stream truncated");
            }
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        SharedFileReader i = this.in;
        if (i == null) {
            throw new IOException("stream closed");
        }
        if (this.length == 0L) {
            return -1;
        }
        int count = i.pread(b, off, len = (int)Math.min(this.length, (long)len), this.position);
        if (count != -1) {
            this.length -= (long)count;
            this.position += (long)count;
        }
        if (count == -1) {
            this.close();
            if (this.length > 0L) {
                throw new IOException("stream truncated");
            }
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        SharedFileReader i = this.in;
        this.in = null;
        if (i != null) {
            i.decref();
        }
    }
}

