/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AggregateStreamWriter
implements Closeable {
    private DataOutputStream dataOut;
    private DigestOutputStream digOut;
    private byte[] buffer;

    public AggregateStreamWriter(OutputStream out, String hashAlgorithm) throws IOException {
        MessageDigest dig = null;
        if (hashAlgorithm == null) {
            hashAlgorithm = "";
        }
        if (hashAlgorithm.length() > 0) {
            try {
                dig = MessageDigest.getInstance(hashAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("unknown hash algorithm: " + hashAlgorithm);
            }
        }
        this.digOut = new DigestOutputStream(out, dig);
        this.digOut.on(false);
        this.dataOut = new DataOutputStream(this.digOut);
        this.dataOut.writeUTF(hashAlgorithm);
        if (dig != null) {
            this.digOut.on(true);
        }
    }

    public void write(AggregateInputStream in) throws IOException {
        this.writeObjectSection(2, in.getItem().getMeta());
        this.writeSection(3, in.getItem().getLength(), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DataOutputStream o = this.dataOut;
        DigestOutputStream digo = this.digOut;
        this.dataOut = null;
        this.digOut = null;
        this.buffer = null;
        if (o != null) {
            try {
                o.writeInt(1);
                o.writeLong(0L);
                digo.on(false);
                MessageDigest dig = digo.getMessageDigest();
                if (dig != null) {
                    byte[] hash = dig.digest();
                    if (hash.length > 65536) {
                        throw new IOException("hash too long");
                    }
                    o.writeShort(hash.length);
                    o.write(hash);
                }
            }
            finally {
                o.close();
            }
        }
    }

    public void writeSection(int type, long length, InputStream in) throws IOException {
        if (this.dataOut == null) {
            throw new IOException("writer closed");
        }
        if (type <= 0 || type == 1) {
            throw new IllegalArgumentException("invalid type");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("invalid length");
        }
        this.dataOut.writeInt(type);
        this.dataOut.writeLong(length);
        if (length > 0L) {
            if (this.buffer == null) {
                this.buffer = new byte[65536];
            }
            while (length > 0L) {
                int len = (int)Math.min(length, (long)this.buffer.length);
                int n = in.read(this.buffer, 0, len);
                if (n == -1) {
                    throw new IOException("stream truncated");
                }
                this.dataOut.write(this.buffer, 0, n);
                length -= (long)n;
            }
        }
    }

    public void writeObjectSection(int type, Object obj) throws IOException {
        if (type <= 0 || type == 1) {
            throw new IllegalArgumentException("invalid type");
        }
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bao);
        oo.writeObject(obj);
        oo.close();
        this.dataOut.writeInt(type);
        this.dataOut.writeLong(bao.size());
        bao.writeTo(this.dataOut);
    }
}

