/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTableHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class ItemTableScanner {
    private final ObjectInputStream in;
    private int headerRecordCount;
    private int readRecordCount;
    private boolean metaOnly;

    public ItemTableScanner(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        this.in = new ObjectInputStream(in);
        try {
            ItemTableHeader header = (ItemTableHeader)this.in.readObject();
            this.headerRecordCount = header.getRecordCount();
            if (this.headerRecordCount < 0) {
                throw new IOException("invalid table stream: recordCount=" + this.headerRecordCount);
            }
            this.metaOnly = header.isMetaOnly();
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("invalid table header").initCause(e);
        }
        catch (ClassCastException e) {
            throw (IOException)new IOException("invalid table header").initCause(e);
        }
    }

    public boolean isMetaOnly() {
        return this.metaOnly;
    }

    public AggregateItem read() throws IOException {
        Object obj;
        do {
            if (this.readRecordCount >= this.headerRecordCount) {
                return null;
            }
            obj = null;
            try {
                obj = this.in.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++this.readRecordCount;
        } while (!(obj instanceof AggregateItem));
        return (AggregateItem)obj;
    }
}

