/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobInputSource;
import com.ibm.uclab.csrepl.blobstore.BlobInputSourceFileMove;
import com.ibm.uclab.csrepl.blobstore.BlobMetadata;
import com.ibm.uclab.csrepl.blobstore.BlobMetadataIterator;
import com.ibm.uclab.csrepl.blobstore.BlobReplicator;
import com.ibm.uclab.csrepl.blobstore.BlobReplicatorFactory;
import com.ibm.uclab.csrepl.blobstore.BlobReplicatorFactoryImpl;
import com.ibm.uclab.csrepl.blobstore.BlobSource;
import com.ibm.uclab.csrepl.blobstore.BlobSourceWaiter;
import com.ibm.uclab.csrepl.blobstore.BlobStore;
import com.ibm.uclab.csrepl.blobstore.BlobStoreOptions;
import com.ibm.uclab.csrepl.blobstore.DiskUsageEstimator;
import com.ibm.uclab.csrepl.blobstore.DiskUsageEstimatorImpl;
import com.ibm.uclab.csrepl.blobstore.OpenBlobResponse;
import com.ibm.uclab.csrepl.blobstore.UnsatisfiableRangeException;
import com.ibm.uclab.csrepl.blobstore.pruner.PruneResult;
import com.ibm.uclab.csrepl.blobstore.pruner.Pruner;
import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.lifecycle.LifecycleThreadFactory;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStreamFactory;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStreamFactoryImpl;
import com.ibm.uclab.csrepl.streams.SubRangeInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class BlobStoreImpl
implements BlobStore {
    private static final Logger log = Logger.getLogger(BlobStoreImpl.class);
    static final int BUFFER_SIZE = 8192;
    private static final String TOMB_MARKER = ".tomb";
    private static final int LOCK_BITS = 4;
    private static final int LOCK_COUNT = 16;
    private final Lifecycle lifecycle;
    private final File dir;
    private final File dataDir;
    private final File tempDir;
    private final File trashDir;
    private final DiskUsageEstimator estimator;
    private final BlobReplicatorFactory replFactory;
    private final MoveableFileInputStreamFactory streamFactory;
    private final Object[] locks;
    private final boolean enableCleanup;
    private final boolean openSetsLastModified;
    private final Map<UUID, BlobReplicator> replicators;
    private final ConcurrentHashMap<UUID, BlobSourceWaiter> activeGets;
    private final ExecutorService executor;
    private final long maxTempFileAge;
    private final long cleanupInterval;
    private Pruner pruner;

    public BlobStoreImpl(File dir) {
        this(dir, null);
    }

    public BlobStoreImpl(File dir, BlobStoreOptions options) {
        this(dir, null, null, null, true, options);
    }

    BlobStoreImpl(File dir, DiskUsageEstimator estimator, BlobReplicatorFactory replFactory, MoveableFileInputStreamFactory streamFactory, boolean enableCleanup, BlobStoreOptions options) {
        this.dir = dir.getAbsoluteFile();
        this.dataDir = new File(dir, "data").getAbsoluteFile();
        this.tempDir = new File(dir, "temp").getAbsoluteFile();
        this.trashDir = new File(dir, "trash").getAbsoluteFile();
        this.dataDir.mkdirs();
        this.tempDir.mkdirs();
        this.trashDir.mkdirs();
        if (estimator == null) {
            estimator = new DiskUsageEstimatorImpl();
        }
        if (replFactory == null) {
            replFactory = new BlobReplicatorFactoryImpl();
        }
        if (streamFactory == null) {
            streamFactory = new MoveableFileInputStreamFactoryImpl(this.tempDir);
        }
        this.lifecycle = this.createLifecycle();
        this.estimator = estimator;
        this.replFactory = replFactory;
        this.streamFactory = streamFactory;
        this.enableCleanup = enableCleanup;
        this.locks = new Object[16];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
        this.replicators = Collections.synchronizedMap(new HashMap());
        this.activeGets = new ConcurrentHashMap();
        this.executor = Executors.newCachedThreadPool((ThreadFactory)((Object)new LifecycleThreadFactory(this.toString() + "-worker")));
        if (options == null) {
            options = new BlobStoreOptions();
        }
        this.maxTempFileAge = options.getMaxTempFileAge();
        this.cleanupInterval = options.getCleanupInterval();
        this.openSetsLastModified = options.isOpenSetsLastModified();
    }

    public synchronized void setPruner(Pruner pruner) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.pruner != null) {
            throw new IllegalStateException("Pruner set");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting pruner: " + pruner));
        }
        this.pruner = pruner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.dir.getAbsolutePath() + "]";
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID addBlob(InputStream in) throws IOException {
        this.lifecycle.checkActive();
        UUID id = UUID.randomUUID();
        byte[] buf = new byte[8192];
        try {
            try (OutputStream out = this.openTempForOutput(id);){
                int n;
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
            }
            this.commitTempFile(id);
            UUID uUID = id;
            return uUID;
        }
        finally {
            this.deleteTempFile(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID addBlob(BlobInputSource in) throws IOException {
        this.lifecycle.checkActive();
        UUID id = UUID.randomUUID();
        if (in.getClass() == BlobInputSourceFileMove.class && this.commitFile(id, ((BlobInputSourceFileMove)in).getFile())) {
            return id;
        }
        try {
            File temp = this.getTempFileForCreation(id);
            in.writeTo(temp);
            this.commitFile(id, temp);
            UUID uUID = id;
            return uUID;
        }
        finally {
            this.deleteTempFile(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openBlob(UUID id) throws IOException {
        this.lifecycle.checkActive();
        File tomb = this.getTombFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            if (tomb.exists()) {
                return null;
            }
            InputStream blob = this.openFromReplicator(id);
            if (blob == null) {
                blob = this.openDataForInput(id);
            }
            return blob;
        }
    }

    @Override
    public OpenBlobResponse openBlob(UUID id, ByteRange range) throws IOException {
        InputStream content = this.openBlob(id);
        if (content == null) {
            return null;
        }
        long blobLength = this.getLength(content);
        ByteContentRange contentRange = null;
        if (range != null) {
            if (blobLength <= 0L || !range.isSatisfiable(blobLength)) {
                content.close();
                throw new UnsatisfiableRangeException(id, range, blobLength, String.format("invalid range: blob=%s range={%s} blobLength=%d", id, range, blobLength));
            }
            long offset = range.getAbsoluteOffset(blobLength);
            long length = range.getAbsoluteLength(blobLength);
            contentRange = ByteContentRange.forKnownLengthEntity(range.asSatisfiedRange(blobLength), blobLength);
            content = new SubRangeInputStream(content, offset, length);
        }
        return new OpenBlobResponse(content, contentRange, blobLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobMetadata getBlobMeta(UUID id) throws IOException {
        this.lifecycle.checkActive();
        File tomb = this.getTombFile(id);
        File data = this.getDataFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            if (tomb.exists()) {
                return null;
            }
            long lastAccessed = data.lastModified();
            long size = data.length();
            if (lastAccessed == 0L && !data.exists()) {
                return null;
            }
            return new BlobMetadata(id, lastAccessed, size);
        }
    }

    @Override
    public Iterable<BlobMetadata> getAllBlobMeta() throws IOException {
        return new Iterable<BlobMetadata>(){

            @Override
            public Iterator<BlobMetadata> iterator() {
                return new BlobMetadataIterator(BlobStoreImpl.this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBlob(UUID id) {
        this.lifecycle.checkActive();
        File tomb = this.getTombFile(id);
        File data = this.getDataFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            if (tomb.exists()) {
                return false;
            }
            if (this.replicators.containsKey(id)) {
                return true;
            }
            return data.exists();
        }
    }

    @Override
    public boolean startReplication(UUID id, BlobSource source) throws IOException {
        return this.startReplication0(id, source, this.executor);
    }

    @Override
    public boolean replicate(UUID id, BlobSource source) throws IOException {
        final Runnable[] replicator = new Runnable[1];
        Executor capture = new Executor(){

            @Override
            public void execute(Runnable command) {
                replicator[0] = command;
            }
        };
        boolean started = this.startReplication0(id, source, capture);
        if (replicator[0] instanceof BlobReplicator) {
            ((BlobReplicator)replicator[0]).doReplicate();
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlob(UUID id) throws IOException {
        this.lifecycle.checkActive();
        Object object = this.getLock(id);
        synchronized (object) {
            this.setTombstone(id);
            File data = this.getDataFile(id);
            this.trashFile(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateDiskUsage(UUID id) throws IOException {
        this.lifecycle.checkActive();
        File tomb = this.getTombFile(id);
        File data = this.getDataFile(id);
        File temp = this.getTempFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            long length;
            if (tomb.exists()) {
                return -1L;
            }
            BlobReplicator repl = this.replicators.get(id);
            if (repl != null && (length = repl.estimateDiskUsage(this.estimator, temp)) != -1L) {
                return length;
            }
            length = this.estimator.estimateFromFile(data);
            if (length == 0L && !data.exists()) {
                return -1L;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pruneBlob(UUID id, long expectLastAccessed) {
        this.lifecycle.checkActive();
        File data = this.getDataFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            if (expectLastAccessed == data.lastModified()) {
                return this.trashFile(data);
            }
        }
        return false;
    }

    File getDataDir() {
        return this.dataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastAccessed(UUID id, long lastAccessed) {
        this.lifecycle.checkActive();
        File data = this.getDataFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            data.setLastModified(lastAccessed);
        }
    }

    void unregisterReplicator(BlobReplicator r) {
        UUID id = r.getId();
        this.replicators.remove(id);
    }

    File commitTempFile(UUID id) throws IOException {
        File temp = this.getTempFile(id);
        File data = this.getDataFile(id);
        if (!this.commitFile(id, temp)) {
            throw new IOException(String.format("Commit failed: data=%s (exists=%s), temp=%s (exists=%s)", data.getAbsolutePath(), data.exists(), temp.getAbsolutePath(), temp.exists()));
        }
        return data;
    }

    boolean commitFile(UUID id, File source) throws IOException {
        File data = this.getDataFileForCreation(id);
        if (!source.isFile() || !source.renameTo(data)) {
            return false;
        }
        data.setLastModified(System.currentTimeMillis());
        return true;
    }

    void deleteTempFile(UUID id) {
        File temp = this.getTempFile(id);
        this.trashFile(temp);
    }

    MoveableFileInputStream openTempForInput(UUID id) throws IOException {
        return this.streamFactory.open(this.getTempFile(id));
    }

    OutputStream openTempForOutput(UUID id) throws IOException {
        File temp = this.getTempFileForCreation(id);
        return new FileOutputStream(temp);
    }

    File getTempFileForCreation(UUID id) throws IOException {
        File temp = this.getTempFile(id);
        if (temp.exists()) {
            throw new IOException("temp file already exists: " + temp.getAbsolutePath());
        }
        this.createParentDir(temp);
        return temp;
    }

    File getDataFileForCreation(UUID id) throws IOException {
        File data = this.getDataFile(id);
        if (data.exists()) {
            throw new IOException("Commit failed: blob already exists: " + id);
        }
        this.createParentDir(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream openDataForInput(UUID id) throws IOException {
        File data = this.getDataFile(id);
        File tomb = this.getTombFile(id);
        Object object = this.getLock(id);
        synchronized (object) {
            if (tomb.exists()) {
                return null;
            }
            try {
                SeekableInputStream in = SeekableInputStreams.adapt((RandomAccessFile)new RandomAccessFile(data, "r"));
                if (this.openSetsLastModified) {
                    data.setLastModified(System.currentTimeMillis());
                }
                return in;
            }
            catch (FileNotFoundException e) {
                if (data.exists()) {
                    throw e;
                }
                return null;
            }
        }
    }

    Object getLock(UUID id) {
        long msb = id.getMostSignificantBits();
        return this.locks[(int)(msb >>> 60)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTombstone(UUID id) throws IOException {
        this.assertLocked(id);
        File tomb = this.getTombFile(id);
        this.createParentDir(tomb);
        try (FileOutputStream out = new FileOutputStream(tomb);){
            byte[] stamp = String.valueOf(System.currentTimeMillis()).getBytes("UTF-8");
            out.write(stamp);
        }
    }

    void removeTombstone(UUID id) throws IOException {
        this.assertLocked(id);
        File tomb = this.getTombFile(id);
        this.trashFile(tomb);
        if (tomb.exists()) {
            throw new IOException("cannot remove tombstone: " + tomb.getAbsolutePath());
        }
    }

    void cleanup() throws InterruptedException {
        this.pruneDataDir();
        this.cleanDataDir();
        this.cleanTempDir();
        this.cleanTrashDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pruneDataDir() {
        Pruner p;
        BlobStoreImpl blobStoreImpl = this;
        synchronized (blobStoreImpl) {
            p = this.pruner;
        }
        if (p != null) {
            try {
                PruneResult r = p.prune(this);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Prune complete: remove %,d blobs, %,d bytes", r.getBlobsPruned(), r.getBytesPruned()));
                }
            }
            catch (IOException e) {
                log.error((Object)("Pruning failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    void cleanDataDir() throws InterruptedException {
        File[] blobDirs = this.dataDir.listFiles();
        if (blobDirs != null) {
            for (File d : blobDirs) {
                String[] names = d.list();
                if (names == null) continue;
                this.cleanBlobDir(d, names);
            }
        }
    }

    void cleanTempDir() throws InterruptedException {
        File[] files = this.tempDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (System.currentTimeMillis() - f.lastModified() <= this.maxTempFileAge) continue;
                this.trashFile(f);
            }
        }
    }

    void purgeTempDir() {
        File[] files = this.tempDir.listFiles();
        if (files != null) {
            for (File f : files) {
                this.trashFile(f);
            }
        }
    }

    void cleanTrashDir() throws InterruptedException {
        File[] files = this.trashDir.listFiles();
        if (files != null) {
            for (File f : files) {
                this.delete(f);
            }
        }
    }

    boolean isBlobName(String s) {
        try {
            UUID.fromString(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    boolean isTombName(String s) {
        if (s.length() != 36 + TOMB_MARKER.length()) {
            return false;
        }
        return this.isBlobName(this.getDataName(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanBlobDir(File dir, String[] names) throws InterruptedException {
        Arrays.sort(names);
        for (String n : names) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean isTomb = this.isTombName(n);
            boolean isBlob = this.isBlobName(n);
            if (!isTomb && !isBlob) {
                File f = new File(dir, n).getAbsoluteFile();
                log.warn((Object)("Removing foreign file: " + f.getAbsolutePath()));
                this.trashFile(f);
                continue;
            }
            if (!isTomb) continue;
            String dn = this.getDataName(n);
            File tomb = new File(dir, n).getAbsoluteFile();
            File data = new File(dir, dn).getAbsoluteFile();
            UUID id = UUID.fromString(dn);
            Object object = this.getLock(id);
            synchronized (object) {
                this.trashFile(data);
                if (!data.exists()) {
                    this.trashFile(tomb);
                }
            }
        }
    }

    private boolean trashFile(File f) {
        File trash = new File(this.trashDir, UUID.randomUUID().toString().toLowerCase(Locale.US));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Trashing file: file=%s, trash=%s", f.getAbsolutePath(), trash.getAbsoluteFile()));
        }
        this.trashDir.mkdirs();
        boolean trashed = f.renameTo(trash);
        if (log.isDebugEnabled() && !trashed) {
            log.debug((Object)String.format("Trashing file: rename failed: file.exists=%s, trash.exists=%s, trashDir.exists=%s", f.exists(), trash.exists(), this.trashDir.exists()));
        }
        return trashed;
    }

    private InputStream openFromReplicator(UUID id) throws IOException {
        this.assertLocked(id);
        BlobReplicator repl = this.replicators.get(id);
        if (repl == null) {
            return null;
        }
        return repl.open();
    }

    File getDataFile(UUID id) {
        String n = this.getFileName(id);
        String dir1 = n.substring(0, 2);
        return this.createFile(this.dataDir, dir1, n);
    }

    private File getTempFile(UUID id) {
        String n = this.getFileName(id);
        return new File(this.tempDir, n);
    }

    private File getTombFile(UUID id) {
        String n = this.getFileName(id) + TOMB_MARKER;
        String dir1 = n.substring(0, 2);
        return this.createFile(this.dataDir, dir1, n);
    }

    private String getFileName(UUID id) {
        return id.toString().toLowerCase(Locale.US);
    }

    private void createParentDir(File f) {
        f.getParentFile().mkdirs();
    }

    private File createFile(File base, String ... names) {
        File f = base;
        for (String n : names) {
            f = new File(f, n);
        }
        return f;
    }

    private void assertLocked(UUID id) {
        if (!Thread.holdsLock(this.getLock(id))) {
            throw new Error("Not holding lock for ID " + id);
        }
    }

    private void delete(File file) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        file.delete();
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.delete(f);
            }
            file.delete();
        }
    }

    private String getDataName(String tombName) {
        return tombName.substring(0, 36);
    }

    private void startCleanupThread() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Thread t = Thread.currentThread();
                t.setName(t.getName() + ": cleaner");
                while (true) {
                    try {
                        while (true) {
                            BlobStoreImpl.this.cleanup();
                            Thread.sleep(BlobStoreImpl.this.cleanupInterval);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)"Terminating due to interrupt", (Throwable)e);
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error during cleanup", e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.executor.execute(r);
    }

    private void start0() {
        this.purgeTempDir();
        if (this.enableCleanup) {
            this.startCleanupThread();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.executor.shutdownNow();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startReplication0(UUID id, BlobSource source, Executor exec) throws IOException {
        BlobSourceWaiter newSource;
        block20: {
            BlobSourceWaiter oldSource;
            if (source == null) {
                throw new NullPointerException("BlobSource is null");
            }
            this.lifecycle.checkActive();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replicating blob " + id));
            }
            File data = this.getDataFile(id);
            newSource = new BlobSourceWaiter(source);
            do {
                Object object = this.getLock(id);
                synchronized (object) {
                    this.removeTombstone(id);
                    if (this.replicators.containsKey(id) || data.exists()) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Blob " + id + " present (or replicating); cancelling new replication request"));
                        }
                        return false;
                    }
                    oldSource = this.activeGets.putIfAbsent(id, newSource);
                }
                if (oldSource == null) break block20;
            } while (!oldSource.await());
            return false;
        }
        boolean getSuccess = false;
        try {
            InputStream in = newSource.get();
            if (in == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("No remote blob " + id + "; cancelling new replication request"));
                }
                getSuccess = true;
                boolean bl = false;
                return bl;
            }
            long length = -1L;
            if (in instanceof SeekableInputStream) {
                length = ((SeekableInputStream)in).length();
            }
            Object object = this.getLock(id);
            synchronized (object) {
                this.deleteTempFile(id);
                OutputStream out = this.openTempForOutput(id);
                BlobReplicator replicator = this.replFactory.create(this, id, in, out, length);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Doing blob replication: " + id));
                }
                this.replicators.put(id, replicator);
                exec.execute(replicator);
                getSuccess = true;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            newSource.setGetSuccess(getSuccess);
            this.activeGets.remove(id, newSource);
        }
    }

    private Lifecycle createLifecycle() {
        return new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                BlobStoreImpl.this.start0();
            }

            @Override
            public void onStop() {
                BlobStoreImpl.this.stop0();
            }
        });
    }

    private long getLength(InputStream blob) throws IOException {
        long length = -1L;
        if (blob instanceof SeekableInputStream) {
            length = ((SeekableInputStream)blob).length();
        }
        return length;
    }
}

