/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.bm;

import com.ibm.uclab.csrepl.bm.BlobByteRangeResult;
import com.ibm.uclab.csrepl.bm.BmConnector2;
import com.ibm.uclab.csrepl.bm.ByteRangeUnsupportedException;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.Errors;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.ibm.uclab.csrepl.http.range.ByteContentRange;
import com.ibm.uclab.csrepl.http.range.ByteContentRangeParser;
import com.ibm.uclab.csrepl.http.range.ByteRange;
import com.ibm.uclab.csrepl.http.range.ContentRangeFormatException;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.streams.AbortingInputStream;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BmConnectorHttp
implements BmConnector2 {
    private static final Logger log = Logger.getLogger(BmConnectorHttp.class);
    private static final Errors errors = new Errors(log);
    private static final String CLIENT_ID_HEADER = "X-Codestation-Client-ID";
    private static final String DIGEST_HEADER = "X-Codestation-Digest-Algorithm";
    private static final String RANGE_HEADER = "Range";
    private static final String CONTENT_RANGE_HEADER = "Content-Range";
    private static final int STATUS_200_OK = 200;
    private static final int STATUS_206_PARTIAL_CONTENT = 206;
    private static final int STATUS_401_UNAUTHORIZED = 401;
    private final Lifecycle lifecycle;
    private final HttpClientWrapper client;
    private final String peerUrl;

    public BmConnectorHttp(HttpClientWrapper client, String peerUrl) {
        while (peerUrl.endsWith("/")) {
            peerUrl = peerUrl.substring(0, peerUrl.length() - 1);
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                BmConnectorHttp.this.start0();
            }

            @Override
            public void onStop() {
                BmConnectorHttp.this.stop0();
            }
        });
        this.peerUrl = peerUrl;
        this.client = client;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.peerUrl + "]";
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.start();
    }

    @Override
    public InputStream openBlob(UUID localId, UUID blobId) throws IOException {
        BlobByteRangeResult r = this.openBlobByteRange(localId, blobId, null);
        if (r != null) {
            return r.getStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BlobByteRangeResult openBlobByteRange(UUID localId, UUID blobId, ByteRange range) throws IOException {
        String path = this.peerUrl + "/bm/blob/" + blobId.toString();
        try {
            HttpGet req = new HttpGet(path);
            req.setHeader(CLIENT_ID_HEADER, localId.toString());
            if (range != null) {
                req.setHeader(RANGE_HEADER, range.toString());
            } else {
                req.setHeader(DIGEST_HEADER, "MD5");
            }
            boolean consumeEntity = true;
            HttpResponse res = this.client.execute((HttpUriRequest)req);
            try {
                StatusLine status = res.getStatusLine();
                int code = status.getStatusCode();
                switch (code) {
                    case 401: {
                        if (!log.isDebugEnabled()) throw new AuthenticationException("Cannot authenticate with server: " + this.peerUrl);
                        log.debug((Object)String.format("Requested failed with unacceptable response: %s: %03d %s", req.getURI(), code, status.getReasonPhrase()));
                        throw new AuthenticationException("Cannot authenticate with server: " + this.peerUrl);
                    }
                    case 200: 
                    case 206: {
                        HttpEntity ent = res.getEntity();
                        long length = -1L;
                        InputStream in = null;
                        if (ent != null) {
                            in = ent.getContent();
                            length = ent.getContentLength();
                        }
                        if (ent == null || in == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Request succeeded without content: %s: %03d %s", req.getURI(), code, status.getReasonPhrase()));
                            }
                            BlobByteRangeResult blobByteRangeResult = null;
                            return blobByteRangeResult;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Request succeeded with content: %s: %03d %s", req.getURI(), code, status.getReasonPhrase()));
                        }
                        in = new AbortingInputStream((HttpUriRequest)req, in);
                        MessageDigest dig = this.getResponseDigest(res);
                        if (dig != null) {
                            if (length != -1L) {
                                length -= (long)dig.getDigestLength();
                            }
                            in = new HashCheckingInputStream(in, dig);
                        }
                        ByteContentRange contentRange = this.getResponseContentRange(res);
                        if (range != null && (contentRange == null || code != 206)) {
                            consumeEntity = false;
                            req.abort();
                            throw new ByteRangeUnsupportedException("incompatible server: byte range request not supported");
                        }
                        in = SeekableInputStreams.adapt((InputStream)in, (long)length);
                        BlobByteRangeResult result = new BlobByteRangeResult(blobId, in, range, contentRange);
                        consumeEntity = false;
                        BlobByteRangeResult blobByteRangeResult = result;
                        return blobByteRangeResult;
                    }
                }
                IOException e = errors.defaultBlobErrorSwitch(blobId, new Errors.CallResult("GET", path, (HttpUriRequest)req, res));
                if (e != null) {
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Request failed with unacceptable response: %s: %03d %s", req.getURI(), code, status.getReasonPhrase()));
                }
                BlobByteRangeResult blobByteRangeResult = null;
                return blobByteRangeResult;
            }
            finally {
                if (consumeEntity) {
                    EntityUtils.consumeQuietly((HttpEntity)res.getEntity());
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void start0() {
        this.client.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.client.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private MessageDigest getResponseDigest(HttpResponse res) throws IOException {
        Header h = res.getFirstHeader(DIGEST_HEADER);
        if (h == null) {
            return null;
        }
        String v = h.getValue();
        if (v == null) {
            return null;
        }
        try {
            return MessageDigest.getInstance(v);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unsupported digest: " + v);
        }
    }

    private ByteContentRange getResponseContentRange(HttpResponse res) throws IOException {
        Header h = res.getFirstHeader(CONTENT_RANGE_HEADER);
        if (h == null) {
            return null;
        }
        String v = h.getValue();
        if (v == null) {
            return null;
        }
        ByteContentRangeParser parser = new ByteContentRangeParser(v);
        try {
            return parser.getContentRange();
        }
        catch (ContentRangeFormatException e) {
            throw new IOException(e);
        }
    }
}

