/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.StreamFactoryArtifactSet;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateReader;
import com.urbancode.codestation2.common.aggregate.AggregateReaderFactory;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.zipwriter.InfoZipUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class CodestationServiceImplAddToZip {
    private final AggregateFactory aggregateFactory;
    private final Copier copier;
    private final ArtifactSetManager artifactSetManager;
    private final BlobManager blobManager;
    private final AggregateReaderFactory readerFactory;
    private final UUID artifactSetId;
    private final ZipArchiveOutputStream zip;
    private final String pathPrefix;

    public CodestationServiceImplAddToZip(ArtifactSetManager artifactSetManager, BlobManager blobManager, AggregateReaderFactory readerFactory, UUID artifactSetId, ZipArchiveOutputStream zip, String pathPrefix) {
        this(artifactSetManager, blobManager, readerFactory, artifactSetId, zip, pathPrefix, new Copier(), new AggregateFactory());
    }

    public CodestationServiceImplAddToZip(ArtifactSetManager artifactSetManager, BlobManager blobManager, UUID artifactSetId, ZipArchiveOutputStream zip, String pathPrefix) {
        this(artifactSetManager, blobManager, null, artifactSetId, zip, pathPrefix, new Copier(), new AggregateFactory());
    }

    public CodestationServiceImplAddToZip(ArtifactSetManager artifactSetManager, BlobManager blobManager, AggregateReaderFactory readerFactory, UUID artifactSetId, ZipArchiveOutputStream zip, String pathPrefix, Copier copier, AggregateFactory aggregateFactory) {
        if (pathPrefix != null && !Aggregate.isPathValid((String)(pathPrefix = Aggregate.sanitizePath((String)pathPrefix)))) {
            throw new IllegalArgumentException("invalid path");
        }
        this.aggregateFactory = aggregateFactory;
        this.aggregateFactory.getClass();
        this.copier = copier;
        this.copier.getClass();
        this.artifactSetManager = artifactSetManager;
        this.artifactSetManager.getClass();
        this.blobManager = blobManager;
        this.blobManager.getClass();
        this.artifactSetId = artifactSetId;
        this.artifactSetId.getClass();
        this.zip = zip;
        this.zip.getClass();
        this.readerFactory = readerFactory;
        this.pathPrefix = pathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException {
        Aggregate aggr = this.aggregateFactory.create(this.artifactSetManager, this.blobManager, this.readerFactory, this.artifactSetId);
        try (AggregateReader reader = aggr.openReader(null);){
            AggregateInputStream in;
            ZipArchiveEntry entry;
            String path;
            int mode;
            InfoZipUtil.Type type;
            for (AggregateItem item : reader.getTable()) {
                if (item.getType() != 2 || item.isMetaOnly()) continue;
                type = InfoZipUtil.Type.DIRECTORY;
                mode = 493;
                if (item.getUnixMode() != null) {
                    mode = item.getUnixMode();
                }
                path = item.getPath();
                if (this.pathPrefix != null) {
                    path = this.pathPrefix + "/" + path;
                }
                entry = new ZipArchiveEntry(path + "/");
                entry.setUnixMode(InfoZipUtil.createUnixMode((InfoZipUtil.Type)type, (int)mode));
                entry.addExtraField(InfoZipUtil.createTimestampField((long)item.getLastModified()));
                entry.setTime(item.getLastModified());
                this.zip.putArchiveEntry((ArchiveEntry)entry);
                this.zip.closeArchiveEntry();
            }
            block13: while ((in = reader.read()) != null) {
                try {
                    AggregateItem item;
                    item = in.getItem();
                    switch (item.getType()) {
                        case 1: {
                            if (item.isMetaOnly()) continue block13;
                            type = InfoZipUtil.Type.FILE;
                            break;
                        }
                        case 3: {
                            type = InfoZipUtil.Type.SYMLINK;
                            break;
                        }
                        default: {
                            continue block13;
                        }
                    }
                    mode = 420;
                    if (item.getUnixMode() != null) {
                        mode = item.getUnixMode();
                    }
                    path = item.getPath();
                    if (this.pathPrefix != null) {
                        path = this.pathPrefix + "/" + path;
                    }
                    entry = new ZipArchiveEntry(path);
                    entry.setUnixMode(InfoZipUtil.createUnixMode((InfoZipUtil.Type)type, (int)mode));
                    entry.addExtraField(InfoZipUtil.createTimestampField((long)item.getLastModified()));
                    entry.setTime(item.getLastModified());
                    this.zip.putArchiveEntry((ArchiveEntry)entry);
                    this.copier.copy((InputStream)in, (OutputStream)this.zip);
                    this.zip.closeArchiveEntry();
                }
                finally {
                    in.close();
                }
            }
            return;
        }
    }

    static class AggregateFactory {
        AggregateFactory() {
        }

        Aggregate create(ArtifactSetManager artifactSetManager, BlobManager blobManager, AggregateReaderFactory readerFactory, UUID artifactSetId) {
            StreamFactoryArtifactSet streamFactory = new StreamFactoryArtifactSet(artifactSetManager, blobManager, artifactSetId);
            return new Aggregate(null, null, (StreamFactory)streamFactory, readerFactory);
        }
    }

    static class Copier {
        Copier() {
        }

        void copy(InputStream in, OutputStream out) throws IOException {
            IO.copy((InputStream)in, (OutputStream)out);
        }
    }
}

