/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTableScanner;
import com.urbancode.codestation2.common.aggregate.PathFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class CodestationServiceImplGetMetadata {
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final UUID id;
    private final PathFilter filter;

    CodestationServiceImplGetMetadata(ArtifactSetManager asm, BlobManager bm, UUID id, Filter filter) {
        this.asm = asm;
        this.bm = bm;
        this.id = id;
        if (filter == null) {
            this.filter = null;
        } else {
            PathFilter pf = filter.toPathFilter();
            if (pf.isAcceptAll()) {
                pf = null;
            }
            this.filter = pf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileMetadata> run() throws IOException {
        try (InputStream table = this.getTableBlob();){
            AggregateItem item;
            ArrayList<FileMetadata> result = new ArrayList<FileMetadata>();
            ItemTableScanner scanner = new ItemTableScanner(table);
            while ((item = scanner.read()) != null) {
                if (this.filter != null && !this.filter.accept(item.getPath())) continue;
                result.add(new FileMetadata(item));
            }
            ArrayList<FileMetadata> arrayList = result;
            return arrayList;
        }
    }

    private InputStream getTableBlob() throws IOException {
        UUID tableId = this.asm.getBlobId(this.id);
        if (tableId == null) {
            throw new FileNotFoundException("No files for artifact set: " + this.id);
        }
        InputStream in = this.bm.openBlob(tableId);
        if (in == null) {
            throw new FileNotFoundException(String.format("No table for artifact set: artifactSetId=%s tableId=%s", this.id, tableId));
        }
        return in;
    }
}

