/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.ptrstore.IDMapping;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReader;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReaderImpl;
import com.ibm.uclab.csrepl.ptrstore.IDMappingReaderPFG;
import com.ibm.uclab.csrepl.ptrstore.PageFileGroup;
import com.ibm.uclab.csrepl.ptrstore.PageFileGroupImpl;
import com.ibm.uclab.csrepl.ptrstore.PtrStore;
import com.ibm.uclab.csrepl.ptrstore.PtrStoreLockManager;
import com.ibm.uclab.csrepl.ptrstore.PtrStoreLockManager2;
import com.ibm.uclab.csrepl.ptrstore.PtrStoreLockManagerMem;
import com.urbancode.commons.util.ObjectUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class PtrStoreFS
implements PtrStore {
    private static final Logger log = Logger.getLogger(PtrStoreFS.class);
    private static final int LOCK_BITS = 4;
    private static final int LOCK_COUNT = 16;
    private static final int PAGE_BITS = 16;
    private static final String PTRS_PREFIX = "ptrs-";
    private static final String PAGE_PATTERN = "ptrs-%04x";
    private final Lifecycle lifecycle;
    private final File dir;
    private final PtrStoreLockManager lockMan;
    private final PtrStoreLockManager2 lockMan2;
    private final File pageDir;
    private final File tempDir;
    private final Object[] locks;

    public PtrStoreFS(File dir, PtrStoreLockManager lockMan) {
        dir = dir.getAbsoluteFile();
        if (lockMan == null) {
            lockMan = new PtrStoreLockManagerMem();
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                PtrStoreFS.this.start0();
            }

            @Override
            public void onStop() {
                PtrStoreFS.this.stop0();
            }
        });
        this.dir = dir.getAbsoluteFile();
        this.lockMan = lockMan;
        this.lockMan2 = lockMan instanceof PtrStoreLockManager2 ? (PtrStoreLockManager2)lockMan : null;
        this.pageDir = new File(dir, "ptr");
        this.tempDir = new File(dir, "tmp");
        this.locks = new Object[16];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.dir.getAbsolutePath() + "]";
    }

    @Override
    public UUID getBlobId(UUID artifactSetId) throws IOException {
        IDMapping m = this.getMapping(artifactSetId);
        if (m == null) {
            return null;
        }
        return m.getBlobId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID compareAndSetBlobId(UUID artifactSetId, UUID expected, UUID update) throws IOException {
        File page = this.toPageFile(artifactSetId);
        File temp = this.toTempFile(artifactSetId);
        this.lockMan.lockById(artifactSetId);
        try {
            IDMapping mapping;
            Map<UUID, IDMapping> ids = this.read(page);
            if (ids == null) {
                ids = new HashMap<UUID, IDMapping>();
            }
            if ((mapping = ids.get(artifactSetId)) == null || mapping.getBlobId().equals(expected)) {
                mapping = mapping == null ? new IDMapping(artifactSetId, update) : mapping.withBlobId(update);
                ids.put(artifactSetId, mapping);
                this.write(temp, ids);
                this.replace(page, temp);
                UUID uUID = null;
                return uUID;
            }
            UUID uUID = mapping.getBlobId();
            return uUID;
        }
        finally {
            this.lockMan.unlockById(artifactSetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID compareAndRemoveBlobId(UUID artifactSetId, UUID expected) throws IOException {
        File page = this.toPageFile(artifactSetId);
        File temp = this.toTempFile(artifactSetId);
        this.lockMan.lockById(artifactSetId);
        try {
            Map<UUID, IDMapping> ids = this.read(page);
            if (ids == null) {
                UUID uUID = null;
                return uUID;
            }
            IDMapping mapping = ids.get(artifactSetId);
            if (mapping == null) {
                UUID uUID = null;
                return uUID;
            }
            UUID blobId = mapping.getBlobId();
            if (!blobId.equals(expected)) {
                UUID uUID = blobId;
                return uUID;
            }
            ids.remove(artifactSetId);
            this.write(temp, ids);
            this.replace(page, temp);
            UUID uUID = null;
            return uUID;
        }
        finally {
            this.lockMan.unlockById(artifactSetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDMapping getMapping(UUID artifactSetId) throws IOException {
        File page = this.toPageFile(artifactSetId);
        this.lockMan.lockById(artifactSetId);
        try {
            Map<UUID, IDMapping> ids = this.read(page);
            if (ids == null) {
                IDMapping iDMapping = null;
                return iDMapping;
            }
            IDMapping iDMapping = ids.get(artifactSetId);
            return iDMapping;
        }
        finally {
            this.lockMan.unlockById(artifactSetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDMapping compareAndSetMapping(IDMapping expected, IDMapping update) throws IOException {
        if (update == null) {
            throw new NullPointerException("update");
        }
        UUID asid = update.getArtifactSetId();
        if (expected != null && !expected.getArtifactSetId().equals(asid)) {
            throw new IllegalArgumentException("Inconsistent artifact set IDs");
        }
        File page = this.toPageFile(asid);
        File temp = this.toTempFile(asid);
        this.lockMan.lockById(asid);
        try {
            IDMapping mapping;
            Map<UUID, IDMapping> ids = this.read(page);
            if (ids == null) {
                ids = new HashMap<UUID, IDMapping>();
            }
            if ((mapping = ids.get(asid)) == null || ObjectUtil.isEqual((Object)mapping, (Object)expected)) {
                ids.put(asid, update);
                this.write(temp, ids);
                this.replace(page, temp);
                IDMapping iDMapping = null;
                return iDMapping;
            }
            IDMapping iDMapping = mapping;
            return iDMapping;
        }
        finally {
            this.lockMan.unlockById(asid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDMapping compareAndRemoveMapping(IDMapping expected) throws IOException {
        UUID asid = expected.getArtifactSetId();
        File page = this.toPageFile(asid);
        File temp = this.toTempFile(asid);
        this.lockMan.lockById(asid);
        try {
            Map<UUID, IDMapping> ids = this.read(page);
            if (ids == null) {
                IDMapping iDMapping = null;
                return iDMapping;
            }
            IDMapping mapping = ids.get(asid);
            if (mapping == null) {
                IDMapping iDMapping = null;
                return iDMapping;
            }
            if (!ObjectUtil.isEqual((Object)mapping, (Object)expected)) {
                IDMapping iDMapping = mapping;
                return iDMapping;
            }
            ids.remove(asid);
            this.write(temp, ids);
            this.replace(page, temp);
            IDMapping iDMapping = null;
            return iDMapping;
        }
        finally {
            this.lockMan.unlockById(asid);
        }
    }

    @Override
    public IDMappingReader getMappingReader() throws IOException {
        if (this.lockMan2 == null) {
            return new IDMappingReaderImpl(this);
        }
        return new IDMappingReaderPFG(this.getPageFileGroups());
    }

    List<? extends PageFileGroup> getPageFileGroups() {
        if (this.lockMan2 == null) {
            throw new UnsupportedOperationException();
        }
        File pageDir = this.getPageDir();
        String[] names = pageDir.list();
        if (names == null) {
            return Collections.emptyList();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        HashMap<Integer, ArrayList<File>> index2files = new HashMap<Integer, ArrayList<File>>();
        for (String name : names) {
            int page = Integer.parseInt(name.substring(PTRS_PREFIX.length()), 16);
            int index = this.lockMan2.getLockIndexByPage(page);
            ArrayList<File> files = (ArrayList<File>)index2files.get(index);
            if (files == null) {
                files = new ArrayList<File>();
                index2files.put(index, files);
            }
            files.add(new File(pageDir, name));
        }
        ArrayList<PageFileGroupImpl> groups = new ArrayList<PageFileGroupImpl>(index2files.size());
        for (Map.Entry e : index2files.entrySet()) {
            groups.add(new PageFileGroupImpl(this, (Integer)e.getKey(), (List)e.getValue()));
        }
        Collections.sort(groups);
        return Collections.unmodifiableList(groups);
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    File getPageDir() {
        return this.pageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<UUID, IDMapping> read(File f) throws IOException {
        HashMap<UUID, IDMapping> hashMap;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        try {
            String line;
            HashMap<UUID, IDMapping> result = new HashMap<UUID, IDMapping>();
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                IDMapping m = new IDMapping(line);
                result.put(m.getArtifactSetId(), m);
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading file: %s: %s", f.getAbsolutePath(), e.getMessage()), e);
            }
        }
        in.close();
        return hashMap;
    }

    void lockByLockIndex(int lockIndex) {
        if (this.lockMan2 == null) {
            throw new UnsupportedOperationException();
        }
        this.lockMan2.lockByLockIndex(lockIndex);
    }

    void unlockByLockIndex(int lockIndex) {
        if (this.lockMan2 == null) {
            throw new UnsupportedOperationException();
        }
        this.lockMan2.unlockByLockIndex(lockIndex);
    }

    void lockByPage(int page) {
        this.lockMan.lockByPage(page);
    }

    void unlockByPage(int page) {
        this.lockMan.unlockByPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File f, Map<UUID, IDMapping> ids) throws IOException {
        assert (f.isAbsolute());
        try {
            String nl = System.getProperty("line.separator");
            File parent = f.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(f);){
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                for (IDMapping m : ids.values()) {
                    out.write(m.toString());
                    out.write(nl);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("Error writing file: %s: %s", f.getAbsolutePath(), e.getMessage()), e);
        }
    }

    private void replace(File old, File rep) throws IOException {
        assert (old.isAbsolute());
        File parent = old.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!rep.renameTo(old)) {
            old.delete();
            if (parent != null) {
                parent.mkdirs();
            }
            if (!rep.renameTo(old)) {
                throw new IOException(String.format("Unable to replace file: old=%s, new=%s", old.getAbsolutePath(), rep.getAbsolutePath()));
            }
        }
    }

    private File toPageFile(UUID id) {
        String n = this.toFileName(id);
        return new File(this.pageDir, n);
    }

    private File toTempFile(UUID id) {
        String n = this.toFileName(id);
        return new File(this.tempDir, n);
    }

    private String toFileName(UUID id) {
        long msb = id.getMostSignificantBits();
        return String.format(PAGE_PATTERN, (int)(msb >>> 48));
    }

    private void start0() {
        this.lockMan.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.lockMan.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }
}

