/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

public class AbortingInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(AbortingInputStream.class);
    private final HttpUriRequest req;
    private final InputStream in;
    private volatile boolean eof;

    public AbortingInputStream(HttpUriRequest req, InputStream in) {
        this.req = req;
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.eof = true;
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = this.in.read(b);
        if (n < 0) {
            this.eof = true;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n < 0) {
            this.eof = true;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        boolean aborting = !this.eof;
        try {
            if (aborting) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Aborting request");
                }
                this.req.abort();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not aborting request: stream at EOF");
            }
        }
        finally {
            block13: {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    if (!aborting) {
                        throw e;
                    }
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)"Suppressed exception after abort", (Throwable)e);
                }
            }
        }
    }
}

