/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.compare;

import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.zos.helpers.InvalidInputException;
import java.io.File;
import java.util.Properties;

public class CompareZosVersionsInputs {
    public static final String VERSION_NAME_1 = "versionName1";
    public static final String VERSION_NAME_2 = "versionName2";
    public static final String COMP_NAME = "compName";
    public static final String RESOURCE_ID = "resourceId";
    public static final String SERVER_URL = "serverUrl";
    private static final String WORK_DIR = System.getProperty("user.dir");
    private final String versionName1;
    private final String versionName2;
    private final String compName;
    private final String resourceId;
    private final String serverUrl;

    private CompareZosVersionsInputs(Properties inputProperties) {
        this.versionName1 = inputProperties.getProperty(VERSION_NAME_1).trim();
        this.versionName2 = inputProperties.getProperty(VERSION_NAME_2).trim();
        this.compName = inputProperties.getProperty(COMP_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.serverUrl = Util.parseServerUrl(inputProperties.getProperty(SERVER_URL).trim());
    }

    public static CompareZosVersionsInputs getValidatedInputs(Properties inputProperties) {
        CompareZosVersionsInputs inputs = new CompareZosVersionsInputs(inputProperties);
        inputs.validate();
        return inputs;
    }

    private void validate() {
        if (this.versionName1.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version-1 is empty");
        }
        if (this.versionName2.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version-2 is empty");
        }
        if (this.versionName2.equals(this.versionName1)) {
            throw new InvalidInputException(" [ERROR] Version-1 and Version-2 are same");
        }
        if (this.compName.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Component Name is empty");
        }
        if (this.resourceId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Resource Id is empty");
        }
    }

    public String getResourceDirPath() {
        return WORK_DIR + File.separator + this.resourceId;
    }

    public String getBaseDirectory1() {
        return this.getResourceDirPath() + File.separator + this.versionName1;
    }

    public String getBaseDirectory2() {
        return this.getResourceDirPath() + File.separator + this.versionName2;
    }

    public String getVersionName1() {
        return this.versionName1;
    }

    public String getVersionName2() {
        return this.versionName2;
    }

    public String getCompName() {
        return this.compName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

