/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.compare;

import com.ibm.urbancode.zos.checksum.ChecksumVerifier;
import com.ibm.urbancode.zos.checksum.InvalidChecksumException;
import com.ibm.urbancode.zos.helpers.FileHelper;
import com.ibm.urbancode.zos.helpers.TarUtil;
import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.zos.compare.CompareZosVersionsInputs;
import com.urbancode.plugins.ucd.vfs.zos.compare.DatasetType;
import com.urbancode.plugins.ucd.vfs.zos.compare.FilesComparator;
import com.urbancode.plugins.ucd.vfs.zos.helpers.InvalidInputException;
import com.urbancode.plugins.ucd.vfs.zos.helpers.VersionDownloader;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;

public class CompareZosVersionsV2 {
    private static final int ERR_CODE = 1;
    private static final String HORIZONTAL_LINE = "********************************************************************************************************************************************************************************************************";
    private final CompareZosVersionsInputs pluginInputs;
    private final AirPluginTool apTool;

    public CompareZosVersionsV2(CompareZosVersionsInputs pluginInputs, AirPluginTool apTool) {
        this.pluginInputs = pluginInputs;
        this.apTool = apTool;
    }

    public static void main(String[] args) {
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties props = apTool.getStepProperties();
            CompareZosVersionsInputs pluginInputs = CompareZosVersionsInputs.getValidatedInputs(props);
            CompareZosVersionsV2 compareZosVersionsV2 = new CompareZosVersionsV2(pluginInputs, apTool);
            compareZosVersionsV2.run();
            System.exit(0);
        }
        catch (InvalidChecksumException | InvalidInputException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private void run() throws Exception {
        this.downloadVersions();
        this.verifyChecksum();
        this.extractPackageZip();
        this.compareVersions();
        this.cleanUpDirectories();
    }

    private void downloadVersions() throws Exception {
        VersionClient ucdVersionClient = this.getVersionClient();
        UUID versionId1 = ucdVersionClient.getVersionId(this.pluginInputs.getCompName(), this.pluginInputs.getVersionName1());
        UUID versionId2 = ucdVersionClient.getVersionId(this.pluginInputs.getCompName(), this.pluginInputs.getVersionName2());
        VersionDownloader versionDownloader = new VersionDownloader(this.pluginInputs.getServerUrl(), this.apTool);
        versionDownloader.download(versionId1, this.pluginInputs.getBaseDirectory1());
        versionDownloader.download(versionId2, this.pluginInputs.getBaseDirectory2());
    }

    private void verifyChecksum() throws IOException, GeneralSecurityException, InvalidChecksumException {
        String checksumPropertiesFilePath;
        String checksumPropertiesFilePath1 = this.pluginInputs.getBaseDirectory1() + File.separator + "versionChecksum.properties";
        if (FileHelper.isFileExist((String)checksumPropertiesFilePath1)) {
            ChecksumVerifier.verify((String)this.pluginInputs.getBaseDirectory1());
        }
        if (FileHelper.isFileExist((String)(checksumPropertiesFilePath = this.pluginInputs.getBaseDirectory2() + File.separator + "versionChecksum.properties"))) {
            ChecksumVerifier.verify((String)this.pluginInputs.getBaseDirectory2());
        }
    }

    private void extractPackageZip() throws Exception {
        String zipFilePath2;
        String zipFilePath1 = this.pluginInputs.getBaseDirectory1() + File.separator + "package.zip";
        if (new File(zipFilePath1).isFile()) {
            TarUtil.untar((String)zipFilePath1, (String)this.pluginInputs.getBaseDirectory1());
        }
        if (new File(zipFilePath2 = this.pluginInputs.getBaseDirectory2() + File.separator + "package.zip").isFile()) {
            TarUtil.untar((String)zipFilePath2, (String)this.pluginInputs.getBaseDirectory2());
        }
    }

    private void compareVersions() throws Exception {
        PackageManifest packageManifest1 = PackageManifest.from((String)(this.pluginInputs.getBaseDirectory1() + File.separator + "packageManifest.xml"));
        List<String> pdsDatasets1 = this.getTextPdsDatasets(packageManifest1);
        List<String> seqDatasets1 = this.getTextSequentialDatasets(packageManifest1);
        PackageManifest packageManifest2 = PackageManifest.from((String)(this.pluginInputs.getBaseDirectory2() + File.separator + "packageManifest.xml"));
        List<String> pdsDatasets2 = this.getTextPdsDatasets(packageManifest2);
        List<String> seqDatasets2 = this.getTextSequentialDatasets(packageManifest2);
        FilesComparator filesComparator = new FilesComparator(this.pluginInputs.getResourceDirPath());
        System.out.println("\n********************************************************************************************************************************************************************************************************");
        this.comparePdsDatasets(pdsDatasets1, pdsDatasets2, filesComparator);
        this.compareSequentialDatasets(seqDatasets1, seqDatasets2, filesComparator);
        System.out.println("\n********************************************************************************************************************************************************************************************************");
    }

    private List<String> getTextPdsDatasets(PackageManifest manifest) {
        return manifest.getAddedContainers().stream().filter(Container::isPds).filter(container -> container.getCopyType() == CopyType.TEXT).map(Container::getSourceContainerName).collect(Collectors.toList());
    }

    private List<String> getTextSequentialDatasets(PackageManifest manifest) {
        return manifest.getAddedContainers().stream().filter(Container::isSequential).filter(container -> container.getCopyType() == CopyType.TEXT).map(Container::getSourceContainerName).collect(Collectors.toList());
    }

    private void cleanUpDirectories() {
        if (FileHelper.isDirectoryExist((String)this.pluginInputs.getBaseDirectory1())) {
            System.out.println("Deleting directory - " + this.pluginInputs.getBaseDirectory1());
            Util.deleteDir(new File(this.pluginInputs.getBaseDirectory1()));
        }
        if (FileHelper.isDirectoryExist((String)this.pluginInputs.getBaseDirectory2())) {
            System.out.println("Deleting directory - " + this.pluginInputs.getBaseDirectory2());
            Util.deleteDir(new File(this.pluginInputs.getBaseDirectory2()));
        }
    }

    private VersionClient getVersionClient() throws URISyntaxException {
        return new VersionClient(new URI(this.pluginInputs.getServerUrl()), this.apTool.getAuthTokenUsername(), this.apTool.getAuthToken());
    }

    private void comparePdsDatasets(List<String> pdsDatasets1, List<String> pdsDatasets2, FilesComparator filesComparator) throws Exception {
        for (String pdsDataset : pdsDatasets1) {
            if (pdsDatasets2.contains(pdsDataset)) {
                System.out.println("\n...Comparing PDS dataset " + pdsDataset + "\n");
                filesComparator.compare("." + File.separator + this.pluginInputs.getVersionName1() + File.separator + pdsDataset, "." + File.separator + this.pluginInputs.getVersionName2() + File.separator + pdsDataset, DatasetType.PDS);
                continue;
            }
            System.out.println(" [INFO] Skipping comparison for PDS Dataset - " + pdsDataset + " as it does not exist in version - " + this.pluginInputs.getVersionName2());
        }
    }

    private void compareSequentialDatasets(List<String> seqDatasets1, List<String> seqDatasets2, FilesComparator filesComparator) throws Exception {
        for (String seqDataset : seqDatasets1) {
            if (seqDatasets2.contains(seqDataset)) {
                System.out.println("\n...Comparing Sequential dataset " + seqDataset + "\n");
                filesComparator.compare("." + File.separator + this.pluginInputs.getVersionName1() + File.separator + seqDataset, "." + File.separator + this.pluginInputs.getVersionName2() + File.separator + seqDataset, DatasetType.SEQ);
                continue;
            }
            System.out.println(" [INFO] Skipping comparison for Sequential Dataset - " + seqDataset + " as it does not exist in version - " + this.pluginInputs.getVersionName2());
        }
    }
}

