/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.download;

import com.ibm.urbancode.zos.linked.version.LinkedVersionInputs;
import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.zos.helpers.InvalidInputException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class DownloadZosVersionInputs
implements LinkedVersionInputs {
    public static final String REPOSITORY_TYPE = "repositoryType";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_ID = "versionId";
    public static final String RESOURCE_ID = "resourceId";
    public static final String DIRECTORY_OFFSET = "directoryOffset";
    public static final String SERVER_URL = "serverUrl";
    private static final String CODESTATION = "CODESTATION";
    public static final String VERSION_TYPE = "versionType";
    public static final String COMPONENT_ID = "compId";
    public static final String CURRENT_VERSION_ID = "currentVersionId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    private static final String WORK_DIR = System.getProperty("user.dir");
    private final String repositoryType;
    private final String versionName;
    private final String versionId;
    private final String resourceId;
    private final String directoryOffset;
    private final String serverUrl;
    private final String versionType;
    private final String fromVersionId;
    private final String componentId;
    private final String componentName;
    private final String deployBasePath;

    private DownloadZosVersionInputs(Properties inputProperties) {
        this.repositoryType = inputProperties.getProperty(REPOSITORY_TYPE).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.directoryOffset = inputProperties.getProperty(DIRECTORY_OFFSET).trim();
        this.serverUrl = Util.parseServerUrl(inputProperties.getProperty(SERVER_URL).trim());
        this.versionType = inputProperties.getProperty(VERSION_TYPE).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.fromVersionId = inputProperties.getProperty(CURRENT_VERSION_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
    }

    public static DownloadZosVersionInputs getValidatedInputs(Properties inputProperties) {
        DownloadZosVersionInputs inputs = new DownloadZosVersionInputs(inputProperties);
        inputs.validate();
        return inputs;
    }

    private void validate() {
        if (this.repositoryType.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Repository Type is empty.");
        }
        if (this.versionName.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version Name is empty.");
        }
        if (this.versionId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version Id is empty.");
        }
        if (this.resourceId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Resource Id is empty.");
        }
        if (!this.repositoryType.equalsIgnoreCase(CODESTATION)) {
            throw new InvalidInputException(" [ERROR] Version is stored in " + this.repositoryType);
        }
        if (this.versionType.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Version Type is empty.");
        }
        if (this.componentId.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Component id is empty.");
        }
        if (this.componentName.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Component name is empty.");
        }
        if (this.deployBasePath.isEmpty()) {
            throw new InvalidInputException(" [ERROR] Deploy base path is empty.");
        }
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getDirectoryOffset() {
        return this.directoryOffset;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getBaseDir() throws IOException {
        String versionDir = WORK_DIR + File.separator + this.resourceId + File.separator + this.versionName;
        if (this.directoryOffset.isEmpty()) {
            return versionDir;
        }
        return new File(versionDir, this.directoryOffset).getCanonicalPath();
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getFromVersionId() {
        return this.fromVersionId;
    }
}

