/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs.zos.helpers;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class VersionDownloader {
    private final String serverUrl;
    private final AirPluginTool apTool;
    private final CodestationClient codestationClient;

    public VersionDownloader(String serverUrl, AirPluginTool apTool) {
        this.serverUrl = serverUrl;
        this.apTool = apTool;
        this.codestationClient = Util.getCodestationClient(serverUrl, false, apTool.getAuthTokenUsername(), apTool.getAuthToken());
    }

    public void download(String versionId, String directoryPath) throws Exception {
        this.download(UUID.fromString(versionId), directoryPath);
    }

    public void downloadLinkedVersions(String componentName, UUID versionId, String fromVersionId, String directoryPath) throws IOException {
        Util.configureLogging();
        System.out.println("Artifact source: " + this.codestationClient.getUrl());
        Download downloadTask = new Download(this.codestationClient, new File(directoryPath), versionId);
        downloadTask.downloadLinkedVersionFiles(componentName, versionId.toString(), fromVersionId);
        System.out.println();
    }

    public void download(UUID versionId, String directoryPath) throws Exception {
        Util.configureLogging();
        System.out.println("Artifact source: " + this.codestationClient.getUrl());
        Download downloadTask = new Download(this.codestationClient, new File(directoryPath), versionId);
        downloadTask.setIncludes(this.getFilesToDownload());
        downloadTask.setOutputCharset(Util.getSystemCharset());
        downloadTask.run();
        System.out.println();
    }

    private List<String> getFilesToDownload() {
        return Arrays.asList("package.zip", "packageManifest.xml", "versionChecksum.properties");
    }
}

