/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.blobstore.BlobInputSourceFileMove;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import com.urbancode.codestation2.common.aggregate.AggregateWriter;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import org.apache.log4j.Logger;

class ArtifactSetBuilderImpl
implements ArtifactSetBuilder {
    private static final Logger log = Logger.getLogger(ArtifactSetBuilderImpl.class);
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final UUID id;
    private final File tempDir;
    private final boolean metadataOnly;
    private Aggregate aggr;
    private AggregateWriter writer;
    private MessageDigest digester;
    private UUID[] newBlobIds;

    ArtifactSetBuilderImpl(ArtifactSetManager asm, BlobManager bm, UUID id, File tempDir, boolean metadataOnly) {
        this.asm = asm;
        this.bm = bm;
        this.id = id;
        this.tempDir = tempDir.getAbsoluteFile();
        this.metadataOnly = metadataOnly;
        File aggrPermDir = new File(tempDir, "perm");
        File aggrTempDir = new File(tempDir, "temp");
        this.aggr = new Aggregate(aggrPermDir, aggrTempDir);
    }

    @Override
    public boolean isMetadataOnly() {
        return this.metadataOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFromLister(FileLister lister) throws IOException {
        if (this.aggr == null) {
            throw new IllegalStateException("Closed");
        }
        this.openWriter();
        this.initDigester();
        for (TypedFile f : lister.list()) {
            File file = f.translate(lister.base());
            try {
                AggregateItem item;
                long mod = file.lastModified();
                switch (f.type()) {
                    case DIRECTORY: {
                        item = this.writer.write(2, f.path(), null, null);
                        break;
                    }
                    case REGULAR: {
                        try (InputStream in = new FileInputStream(file);){
                            int type = 1;
                            if (this.metadataOnly) {
                                type |= Integer.MIN_VALUE;
                            }
                            item = this.writer.write(type, f.path(), in, this.digester);
                            break;
                        }
                    }
                    case SYMLINK: {
                        InputStream in = new ByteArrayInputStream(f.linkPath().getBytes(IO.utf8()));
                        item = this.writer.write(3, f.path(), in, this.digester);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case: " + f.type());
                    }
                }
                item.setLastModified(mod);
                this.setPerms(item, (UnixPermissions)f.permissionView(UnixPermissions.class));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    @Override
    public void addItem(FileMetadata meta, InputStream content) throws IOException {
        if (this.aggr == null) {
            throw new IllegalStateException("Closed");
        }
        if (meta.getType() == FileMetadata.Type.DIRECTORY && content != null) {
            throw new IllegalArgumentException("Directory type cannot accept content");
        }
        if (meta.getType() == FileMetadata.Type.SYMLINK && content == null && !this.metadataOnly) {
            throw new NullPointerException("Symlink type must have link target as content");
        }
        this.openWriter();
        this.initDigester();
        AggregateItemMeta m = meta.toAggregateItemMeta(this.metadataOnly);
        if (content == null && this.metadataOnly) {
            long length = meta.getLength();
            if (meta.getType() == FileMetadata.Type.DIRECTORY) {
                length = 0L;
            }
            this.writer.writeZero(m, length, null);
        } else {
            this.writer.write(m, content, this.digester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        if (this.aggr != null) {
            this.openWriter();
            Aggregate ag = this.aggr;
            AggregateWriter wr = this.writer;
            this.aggr = null;
            this.writer = null;
            this.digester = null;
            boolean ok = false;
            try {
                wr.close();
                if (wr.isAggregateModified()) {
                    File dataFile = wr.getDataFile();
                    UUID tableId = this.uploadBlobs(ag, dataFile);
                    this.asm.setBlobId(this.id, tableId);
                }
                ok = true;
            }
            finally {
                try {
                    if (!ok) {
                        this.removeNewBlobs();
                    }
                }
                finally {
                    this.newBlobIds = null;
                    if (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
                        for (int i = 0; i < 5; ++i) {
                            try {
                                IO.delete((File)this.tempDir);
                                return;
                            }
                            catch (IOException e) {
                                try {
                                    Thread.sleep(50L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        log.error((Object)("failed to delete tempDir: " + this.tempDir.getPath()));
                    } else {
                        IO.delete((File)this.tempDir);
                    }
                }
            }
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.aggr != null) {
            AggregateWriter wr = this.writer;
            this.aggr = null;
            this.writer = null;
            this.digester = null;
            this.newBlobIds = null;
            try {
                if (wr != null) {
                    wr.abort();
                }
            }
            finally {
                IO.delete((File)this.tempDir);
            }
        }
    }

    private void openWriter() throws IOException {
        if (this.writer == null) {
            this.newBlobIds = new UUID[2];
            this.initAggregateFromExistingArtifactSet();
            this.writer = this.aggr.openWriter();
            this.writer.setMetaOnly(this.metadataOnly);
        }
    }

    private void initDigester() throws IOException {
        if (this.digester == null) {
            try {
                this.digester = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void initAggregateFromExistingArtifactSet() throws IOException {
        UUID tableId = this.asm.getBlobId(this.id);
        if (tableId == null) {
            return;
        }
        InputStream in = this.bm.openBlob(tableId);
        if (in == null) {
            return;
        }
        File f = this.aggr.getTableFile().getAbsoluteFile();
        f.getParentFile().mkdirs();
        IO.copy((InputStream)in, (File)f);
    }

    private UUID uploadBlobs(Aggregate aggr, File dataFile) throws IOException {
        int i = 0;
        UUID dataId = null;
        if (dataFile != null) {
            dataId = this.bm.addBlob(new BlobInputSourceFileMove(dataFile));
            this.newBlobIds[i++] = dataId;
            aggr.renameDataFiles(Collections.singletonMap(dataFile.getName(), dataId.toString()));
        }
        UUID tableId = this.bm.addBlob(new BlobInputSourceFileMove(aggr.getTableFile()));
        this.newBlobIds[i++] = tableId;
        return tableId;
    }

    private void removeNewBlobs() throws IOException {
        if (this.newBlobIds == null) {
            return;
        }
        for (UUID id : this.newBlobIds) {
            if (id == null) continue;
            this.bm.removeBlobLocal(id);
        }
    }

    private void setPerms(AggregateItem item, UnixPermissions perms) {
        if (perms == null) {
            return;
        }
        String user = perms.getUser();
        String group = perms.getGroup();
        int mode = perms.getMode();
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (group != null && group.length() == 0) {
            group = null;
        }
        item.setUnixUser(user);
        item.setUnixGroup(group);
        item.setUnixMode(Integer.valueOf(mode));
    }
}

