/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStreams;
import com.urbancode.codestation2.common.aggregate.streams.StreamFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

class StreamFactoryArtifactSet
implements StreamFactory {
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final UUID asid;

    StreamFactoryArtifactSet(ArtifactSetManager asm, BlobManager bm, UUID asid) {
        this.asm = asm;
        this.bm = bm;
        this.asid = asid;
    }

    public SeekableInputStream openInput(String name) throws IOException {
        UUID dataId;
        if (name.equals(".urbancode-file-table")) {
            UUID tableId = this.asm.getBlobId(this.asid);
            if (tableId == null) {
                throw new FileNotFoundException("No files for artifact set: " + this.asid);
            }
            InputStream table = this.bm.openBlob(tableId);
            if (table == null) {
                throw new FileNotFoundException(String.format("No table for artifact set: artifactSetId=%s tableId=%s", this.asid, tableId));
            }
            return SeekableInputStreams.adapt((InputStream)table);
        }
        try {
            dataId = UUID.fromString(name);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid blob ID: " + name);
        }
        InputStream in = this.bm.openBlob(dataId);
        if (in == null) {
            throw new FileNotFoundException(String.format("No data blob for artifact set: artifactSetId=%s, dataId=%s", this.asid, dataId));
        }
        return SeekableInputStreams.adapt((InputStream)in);
    }
}

