/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.Download;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.plugins.ucd.vfs.Util;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ZosDownloadHelper {
    static final String PACKAGE_ZIP = "package.zip";
    static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    static final String ENCODING_CP037 = "CP037";
    static final String MANIFEST_NODE = "manifest";
    static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    private String manifestPath = "";
    private File baseDirectory;
    private String repositoryType;
    private String versionName;
    private UUID versionId;
    private String resourceId;
    private String directoryOffset;
    private String serverUrl;
    private Charset charset;
    private AirPluginTool apTool;
    private boolean printFlag;

    public ZosDownloadHelper(String repositoryType, String versionName, UUID versionId, String resourceId, String directoryOffset, String serverUrl, Charset charset, AirPluginTool apTool, boolean printFlag) {
        this.repositoryType = repositoryType;
        this.versionName = versionName;
        this.versionId = versionId;
        this.resourceId = resourceId;
        this.directoryOffset = directoryOffset;
        this.serverUrl = serverUrl;
        this.charset = charset;
        this.apTool = apTool;
        this.printFlag = printFlag;
    }

    public void downloadVersion() throws Exception {
        File workDir;
        if (!"CODESTATION".equalsIgnoreCase(this.repositoryType)) {
            if ("HFS".equalsIgnoreCase(this.repositoryType)) {
                System.out.println(" [ERROR] Version " + this.versionName + "(" + this.versionId + ") is stored in zOS HFS. Use Copy Artifacts or FTP Artifacts plug-in steps to retrieve the version artifacts.");
            } else {
                System.out.println(" [ERROR] Version " + this.versionName + "(" + this.versionId + ") is not stored in CodeStation.");
            }
            throw new Exception("Download failed.");
        }
        this.baseDirectory = workDir = new File("." + File.separator + this.resourceId + File.separator + this.versionName).getCanonicalFile();
        if (this.directoryOffset != null) {
            this.baseDirectory = new File(workDir, this.directoryOffset).getCanonicalFile();
        }
        if (this.baseDirectory.exists() && this.baseDirectory.isDirectory()) {
            if (this.printFlag) {
                System.out.println("Deleting base directory - " + this.baseDirectory);
            }
            Util.deleteDir(this.baseDirectory);
        }
        this.baseDirectory.mkdirs();
        if (this.baseDirectory.isFile()) {
            throw new IllegalArgumentException("Base directory " + this.baseDirectory + " is a file");
        }
        if (this.printFlag) {
            Util.configureLogging();
        } else {
            Logger.getLogger((String)"com.ibm.uclab.csrepl.client.ops").setLevel(Level.OFF);
        }
        CodestationClient csClient = Util.getCodestationClient(this.serverUrl, false, this.apTool.getAuthTokenUsername(), this.apTool.getAuthToken());
        Download op = new Download(csClient, this.baseDirectory, this.versionId);
        op.setIncludes(Arrays.asList(PACKAGE_ZIP, PACKAGE_MANIFEST_XML));
        op.setOutputCharset(this.charset);
        if (this.printFlag) {
            System.out.println("Artifact source: " + csClient.getUrl());
            System.out.println("Working directory: " + this.baseDirectory);
            System.out.println("Offset " + this.directoryOffset);
            System.out.println();
        }
        op.run();
        File pkgManifestFile = new File(this.baseDirectory, PACKAGE_MANIFEST_XML);
        if (!pkgManifestFile.exists()) {
            throw new Exception(" [ERROR] packageManifest.xml not found in CodeStation");
        }
        this.manifestPath = pkgManifestFile.getCanonicalPath();
    }

    public void extractVersion() throws Exception {
        File zipFile = new File(this.baseDirectory, PACKAGE_ZIP);
        if (zipFile.exists()) {
            Processes processes = new Processes();
            String[] cmdArgs = new String[]{"pax", "-r", "-vf", zipFile.getPath()};
            Process process = new ProcessBuilder(cmdArgs).directory(this.baseDirectory).start();
            process.getOutputStream().close();
            Future<String> sout = processes.getOutputStringFuture(process);
            Future<String> serr = processes.getErrorStringFuture(process);
            process.waitFor();
            if (process.exitValue() > 0) {
                System.out.println("Process Output : \n" + sout.get());
                System.out.println("Process Error : \n" + serr.get());
                throw new Exception(" [ERROR] While extracting files from package.zip");
            }
            zipFile.renameTo(new File(this.baseDirectory, "processed_package.zip"));
            if (this.printFlag) {
                System.out.println("Deployment package extracted successfully");
            }
        }
    }

    public boolean isSecondVersion() throws Exception {
        FileInputStream shipListFileStream = null;
        boolean manifestNodeFound = false;
        boolean isNewPackage = false;
        shipListFileStream = new FileInputStream(this.manifestPath);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader shiplistEventReader = inputFactory.createXMLEventReader(shipListFileStream, ENCODING_CP037);
        while (shiplistEventReader.hasNext() && !manifestNodeFound) {
            XMLEvent shipListReaderEvent = shiplistEventReader.nextEvent();
            switch (shipListReaderEvent.getEventType()) {
                case 1: {
                    StartElement startElement = shipListReaderEvent.asStartElement();
                    String nodeName = startElement.getName().getLocalPart().trim();
                    if (!MANIFEST_NODE.equalsIgnoreCase(nodeName)) break;
                    String versionValue = ZosDownloadHelper.getAttributeValue(startElement, MANIFEST_VERSION_ATTRIBUTE);
                    manifestNodeFound = true;
                    if (versionValue != null && versionValue.equals("v2_0")) {
                        isNewPackage = true;
                        break;
                    }
                    isNewPackage = false;
                    break;
                }
            }
        }
        shipListFileStream.close();
        return isNewPackage;
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            String value;
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().trim().equalsIgnoreCase(attributeName) || null == (value = attr.getValue())) continue;
            return value.trim();
        }
        return null;
    }
}

