/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public abstract class AggregateReader
implements Closeable {
    protected ItemTable table;
    protected Iterator<AggregateItem> iterator;

    public AggregateReader(ItemTable table) {
        this.table = table;
        this.iterator = table.iterator();
    }

    public abstract AggregateInputStream read(String var1) throws IOException;

    public abstract AggregateInputStream read(AggregateItem var1) throws IOException;

    public abstract AggregateInputStream read() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public ItemTable getTable() {
        if (this.table == null) {
            throw new IllegalStateException("reader closed");
        }
        return this.table;
    }

    public boolean isMetaOnly() {
        if (this.table == null) {
            throw new IllegalStateException("reader closed");
        }
        return this.table.isMetaOnly();
    }

    public void rewind() throws IOException {
        if (this.table == null) {
            throw new IOException("reader closed");
        }
        this.iterator = this.table.iterator();
    }
}

