/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import java.io.FileInputStream;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZosManifestHelper {
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String CONTAINER_TYPE_SEQ_VALUE = "sequential";
    private static final String DELETE_ACTION_NODE = "deleted";
    private static final String TEXT = "TEXT";
    private static final String TypeKey = "type";
    private static final String NameKey = "name";
    private static final String CopyTypeKey = "copyType";
    private static final String ContainerTag = "container";
    private static final String packageManifestFileEncoding = "CP037";
    private static final String PACKAGE_MANIFEST = "packageManifest.xml";
    private HashSet<String> pdsSet = new HashSet();
    private HashSet<String> seqSet = new HashSet();
    private HashSet<String> pdsDeleteSet = new HashSet();
    private HashSet<String> seqDeleteSet = new HashSet();

    public HashSet<String> getPdsSet() {
        return this.pdsSet;
    }

    public HashSet<String> getSeqSet() {
        return this.seqSet;
    }

    public HashSet<String> getPdsDeletedSet() {
        return this.pdsDeleteSet;
    }

    public HashSet<String> getSeqDeletedSet() {
        return this.seqDeleteSet;
    }

    public void createManifestDataStructure(String manifestFilePath) throws Exception {
        FileInputStream manifestInputStream = new FileInputStream(manifestFilePath + "/" + PACKAGE_MANIFEST);
        boolean nestedInDeletedContainer = false;
        String containerMapKey = "";
        String containerCopyType = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4ManifestXml = null;
        eventReader4ManifestXml = inputFactory.createXMLEventReader(manifestInputStream, packageManifestFileEncoding);
        while (eventReader4ManifestXml.hasNext()) {
            XMLEvent shipListReaderEvent = eventReader4ManifestXml.nextEvent();
            switch (shipListReaderEvent.getEventType()) {
                case 7: {
                    break;
                }
                case 1: {
                    StartElement startElement = shipListReaderEvent.asStartElement();
                    String nodeName = startElement.getName().getLocalPart().trim();
                    if (DELETE_ACTION_NODE.equalsIgnoreCase(nodeName)) {
                        nestedInDeletedContainer = true;
                        break;
                    }
                    if (!ContainerTag.equalsIgnoreCase(nodeName)) break;
                    String containerType = ZosManifestHelper.getAttributeValue(startElement, TypeKey);
                    containerMapKey = ZosManifestHelper.getAttributeValue(startElement, NameKey);
                    containerCopyType = ZosManifestHelper.getAttributeValue(startElement, CopyTypeKey);
                    if (containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQ_VALUE) || containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
                        if (nestedInDeletedContainer) {
                            if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
                                this.pdsDeleteSet.add(containerMapKey);
                                break;
                            }
                            this.seqDeleteSet.add(containerMapKey);
                            break;
                        }
                        if (containerCopyType.equalsIgnoreCase(TEXT)) {
                            if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
                                this.pdsSet.add(containerMapKey);
                                break;
                            }
                            this.seqSet.add(containerMapKey);
                            break;
                        }
                        System.out.println(" [INFO] Skipping comparison for container - " + containerMapKey + " as it is of type - " + containerCopyType);
                        break;
                    }
                    System.out.println(" [INFO] Skipping comparison for container '" + containerMapKey + "' as it is of type HFS.");
                    break;
                }
                case 8: {
                    break;
                }
                case 2: {
                    EndElement endElement = shipListReaderEvent.asEndElement();
                    String endNodeName = endElement.getName().getLocalPart().trim();
                    if (!DELETE_ACTION_NODE.equalsIgnoreCase(endNodeName)) break;
                    nestedInDeletedContainer = false;
                    break;
                }
            }
        }
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        String attrValue = null;
        QName qn = new QName(attributeName);
        Attribute attribute = startElement.getAttributeByName(qn);
        if (null != attribute) {
            attrValue = attribute.getValue().trim();
        }
        return attrValue;
    }
}

