/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client;

import com.ibm.uclab.csrepl.client.ArtifactSetReaderImpl;
import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.exceptions.Errors;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.ibm.uclab.csrepl.streams.ArtifactSetReaderInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

class ArtifactSetBuilderClientData
implements ArtifactSetBuilder,
Runnable {
    private static final Logger log = Logger.getLogger(ArtifactSetBuilderClientData.class);
    private final UUID artifactSetId;
    private final HttpClientWrapper client;
    private final String serviceUrl;
    private final ArtifactSetReaderImpl reader;
    private final ArtifactSetReaderInputStream in;
    private final HashInjectingInputStream hashIn;
    private boolean aborted;
    private boolean committed;
    private Thread uploader;
    private volatile Throwable uploaderError;

    ArtifactSetBuilderClientData(UUID artifactSetId, HttpClientWrapper client, String serviceUrl) {
        this.artifactSetId = artifactSetId;
        this.client = client;
        this.serviceUrl = serviceUrl;
        this.reader = new ArtifactSetReaderImpl(this);
        this.in = new ArtifactSetReaderInputStream(this.reader);
        this.hashIn = new HashInjectingInputStream(this.in, IO.md5Digester());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFromLister(FileLister lister) throws IOException {
        if (this.committed || this.aborted) {
            throw new IOException("Closed");
        }
        this.initStream();
        for (TypedFile f : lister.list()) {
            this.checkForUploaderError();
            File file = f.translate(lister.base());
            try {
                InputStream data;
                FileMetadata.Type type;
                switch (f.type()) {
                    case DIRECTORY: {
                        type = FileMetadata.Type.DIRECTORY;
                        data = null;
                        break;
                    }
                    case REGULAR: {
                        type = FileMetadata.Type.FILE;
                        data = new FileInputStream(file);
                        break;
                    }
                    case SYMLINK: {
                        type = FileMetadata.Type.SYMLINK;
                        data = new ByteArrayInputStream(f.linkPath().getBytes(IO.utf8()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case: " + f.type());
                    }
                }
                try {
                    FileMetadata meta = new FileMetadata(type, f.path(), 0L);
                    meta.setLastModified(file.lastModified());
                    this.setPerms(meta, (UnixPermissions)f.permissionView(UnixPermissions.class));
                    this.reader.add(data, meta);
                }
                finally {
                    if (data == null) continue;
                    data.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    @Override
    public void addItem(FileMetadata meta, InputStream content) throws IOException {
        if (this.committed || this.aborted) {
            throw new IOException("Closed");
        }
        this.initStream();
        meta = meta.copy();
        if (meta.getType() == FileMetadata.Type.DIRECTORY && content != null) {
            throw new IllegalArgumentException("Directory type cannot accept content");
        }
        if (meta.getType() == FileMetadata.Type.SYMLINK && content == null) {
            throw new NullPointerException("Symlink type must have link target as content");
        }
        this.checkForUploaderError();
        this.reader.add(content, meta);
    }

    @Override
    public void commit() throws IOException {
        if (!this.aborted && !this.committed) {
            this.committed = true;
            this.initStream();
            this.reader.close();
            try {
                this.uploader.join();
            }
            catch (InterruptedException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Interrupted", (Throwable)e);
                }
                this.aborted = true;
                this.committed = false;
                this.hashIn.abort();
            }
            this.checkForUploaderError();
        }
    }

    @Override
    public void abort() throws IOException {
        block4: {
            if (!this.aborted && !this.committed) {
                this.aborted = true;
                this.hashIn.abort();
                this.reader.close();
                if (this.uploader != null) {
                    try {
                        this.uploader.join();
                    }
                    catch (InterruptedException swallow) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)"Interrupted", (Throwable)swallow);
                    }
                }
            }
        }
    }

    @Override
    public boolean isMetadataOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            String reqUrl = String.format("%s/%s/update", this.serviceUrl, this.artifactSetId);
            HttpPost req = new HttpPost(reqUrl);
            ContentType ct = ContentType.parse((String)("multipart/mixed; boundary=\"" + this.in.getBoundary() + "\""));
            req.setHeader("X-Codestation-Digest-Algorithm", "MD5");
            req.setEntity((HttpEntity)new InputStreamEntity((InputStream)this.hashIn, -1L, ct));
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName(name + ": POST " + reqUrl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing: POST " + req.getURI()));
            }
            Errors.CallResult result = new Errors.CallResult("POST", reqUrl, (HttpRequestBase)req, this.client.execute((HttpUriRequest)req));
            try {
                StatusLine status = result.res.getStatusLine();
                switch (status.getStatusCode()) {
                    case 204: {
                        if (!log.isDebugEnabled()) return;
                        log.debug((Object)String.format("Request succeeded: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                        return;
                    }
                    default: {
                        throw CodestationClient.errors.defaultArtifactSetErrorSwitch(this.artifactSetId, result);
                    }
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)result.res.getEntity());
            }
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception in uploader: " + e.getMessage()), e);
            }
            try {
                this.hashIn.abort();
                this.uploaderError = e;
                return;
            }
            catch (Throwable swallow) {
                try {
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)("Swallowing: " + swallow), swallow);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.uploaderError = e;
                }
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Uploader terminating");
            }
        }
    }

    void checkForUploaderError() throws IOException {
        Throwable ue = this.uploaderError;
        if (ue != null) {
            throw new IOException(ue.getMessage(), ue);
        }
    }

    private void initStream() throws IOException {
        if (this.uploader == null) {
            this.uploader = new Thread(this);
            this.uploader.setDaemon(true);
            this.uploader.setName("Uploader[" + this.artifactSetId + "]");
            this.uploader.start();
        }
        this.checkForUploaderError();
    }

    private void setPerms(FileMetadata meta, UnixPermissions perms) {
        if (perms == null) {
            return;
        }
        String user = perms.getUser();
        String group = perms.getGroup();
        int mode = perms.getMode();
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (group != null && group.length() == 0) {
            group = null;
        }
        meta.setUnixUser(user);
        meta.setUnixGroup(group);
        meta.setUnixMode(mode);
    }
}

