/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.client.ops.DownloadBase;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Upload {
    private static final Logger log = Logger.getLogger(DownloadBase.class);
    protected PrintStream messageStream;
    protected CodestationClient client;
    protected File source;
    protected UUID artifactSetId;
    protected List<String> includes;
    protected List<String> excludes;
    protected List<String> textFileExtensions;
    protected Charset textFileCharset;
    protected boolean saveExecuteBits;
    protected boolean metadataOnly;

    public Upload(CodestationClient client, File source, UUID artifactSetId) {
        this.client = client;
        this.source = source;
        this.artifactSetId = artifactSetId;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setIncludes(List<String> includes) {
        if (includes != null) {
            includes = new ArrayList<String>(includes);
        }
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        if (excludes != null) {
            excludes = new ArrayList<String>(excludes);
        }
        this.excludes = excludes;
    }

    public void setTextFileExtensions(List<String> textFileExtensions) {
        if (textFileExtensions != null) {
            ArrayList<String> exts = new ArrayList<String>(textFileExtensions.size());
            for (String ext : textFileExtensions) {
                ext = ext.trim();
                while (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                if ((ext = ext.trim()).length() <= 0) continue;
                ext = "." + ext;
                exts.add(ext);
            }
            textFileExtensions = exts;
        }
        this.textFileExtensions = textFileExtensions;
    }

    public void setTextFileCharset(Charset textFileCharset) {
        this.textFileCharset = textFileCharset;
    }

    public void setSaveExecuteBits(boolean saveExecuteBits) {
        this.saveExecuteBits = saveExecuteBits;
    }

    public void setMetadataOnly(boolean metadataOnly) {
        this.metadataOnly = metadataOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        List files;
        this.print("Uploading files in " + this.source.getAbsolutePath());
        FileListerBuilder flb = new FileListerBuilder(this.source);
        flb.directories(FileListerBuilder.Directories.INCLUDE_ALL);
        flb.symlinks(FileListerBuilder.Symlinks.AS_LINK);
        if (this.saveExecuteBits) {
            flb.permissions(FileListerBuilder.Permissions.FILE_EXECUTE_ONLY);
        }
        if (this.includes != null) {
            flb.includes().addAll(this.includes);
        }
        if (this.excludes != null) {
            flb.excludes().addAll(this.excludes);
        }
        if ((files = flb.build().list()).isEmpty()) {
            this.print("Found no files");
            return;
        }
        boolean committed = false;
        ArtifactSetBuilder builder = this.metadataOnly ? this.client.createMetadataOnlyBuilder(this.artifactSetId) : this.client.createBuilder(this.artifactSetId);
        try {
            for (TypedFile f : files) {
                File file = f.translate(this.source);
                try {
                    InputStream content;
                    FileMetadata.Type type;
                    switch (f.type()) {
                        case DIRECTORY: {
                            type = FileMetadata.Type.DIRECTORY;
                            content = null;
                            break;
                        }
                        case REGULAR: {
                            type = FileMetadata.Type.FILE;
                            content = new FileInputStream(file);
                            break;
                        }
                        case SYMLINK: {
                            type = FileMetadata.Type.SYMLINK;
                            content = new ByteArrayInputStream(f.linkPath().getBytes(IO.utf8()));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Missing case: " + f.type());
                        }
                    }
                    try {
                        FileMetadata meta = new FileMetadata(type, f.path(), 0L);
                        meta.setLastModified(file.lastModified());
                        this.setCharset(meta);
                        this.setPerms(meta, (UnixPermissions)f.permissionView(UnixPermissions.class));
                        this.print("Uploading: " + meta.getPath());
                        builder.addItem(meta, content);
                    }
                    finally {
                        if (content == null) continue;
                        content.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            builder.commit();
            committed = true;
            this.print("Files committed");
        }
        finally {
            builder.abort();
            if (!committed) {
                this.print("Upload aborted due to error");
            }
        }
    }

    private void setCharset(FileMetadata meta) {
        if (this.textFileCharset == null || this.textFileExtensions == null || this.textFileExtensions.isEmpty()) {
            return;
        }
        for (String ext : this.textFileExtensions) {
            if (!meta.getPath().endsWith(ext)) continue;
            meta.setCharset(this.textFileCharset.name());
            break;
        }
    }

    private void setPerms(FileMetadata meta, UnixPermissions perms) {
        if (!this.saveExecuteBits || perms == null) {
            return;
        }
        String user = perms.getUser();
        String group = perms.getGroup();
        int mode = perms.getMode();
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (group != null && group.length() == 0) {
            group = null;
        }
        meta.setUnixUser(user);
        meta.setUnixGroup(group);
        meta.setUnixMode(mode);
    }

    private void print(String msg) {
        if (this.messageStream == null) {
            log.info((Object)msg);
        } else {
            this.messageStream.println(msg);
        }
    }
}

