/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.ptrstore;

import com.ibm.uclab.csrepl.ptrstore.PtrStoreLockManager2;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PtrStoreLockManagerMem
implements PtrStoreLockManager2 {
    private static final int LOCK_BITS = 4;
    private static final int LOCK_COUNT = 16;
    private static final int PAGE_BITS = 16;
    private final Lock[] locks = new ReentrantLock[16];

    public PtrStoreLockManagerMem() {
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public void lockById(UUID id) {
        this.getLockByID(id).lock();
    }

    @Override
    public void unlockById(UUID id) {
        this.getLockByID(id).unlock();
    }

    @Override
    public void lockByPage(int page) {
        this.getLockByPage(page).lock();
    }

    @Override
    public void unlockByPage(int page) {
        this.getLockByPage(page).unlock();
    }

    @Override
    public int getLockIndexById(UUID id) {
        long msb = id.getMostSignificantBits();
        return (int)(msb >>> 60);
    }

    @Override
    public int getLockIndexByPage(int page) {
        return page >>> 12;
    }

    @Override
    public void lockByLockIndex(int lockIndex) {
        this.getLockByIndex(lockIndex).lock();
    }

    @Override
    public void unlockByLockIndex(int lockIndex) {
        this.getLockByIndex(lockIndex).unlock();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private Lock getLockByID(UUID id) {
        return this.locks[this.getLockIndexById(id)];
    }

    private Lock getLockByPage(int page) {
        return this.locks[this.getLockIndexByPage(page)];
    }

    private Lock getLockByIndex(int index) {
        return this.locks[index];
    }
}

