/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AggregateItemMeta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int type;
    private final String path;
    private long lastModified;
    private String hash;
    private Integer unixMode;
    private String unixUser;
    private String unixGroup;
    private String charset;
    private String zosDeployType;
    private String zosDeployAction;
    private String zosContainerType;
    private String userAttributes;

    public AggregateItemMeta(int typeWithFlags, String path) {
        path = Aggregate.sanitizePath(path);
        if (!Aggregate.isPathValid(path)) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        this.type = typeWithFlags;
        this.path = path;
    }

    public int getType() {
        int t = this.type;
        return t &= Integer.MAX_VALUE;
    }

    public int getTypeWithFlags() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isMetaOnly() {
        return (this.type & Integer.MIN_VALUE) != 0;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getUnixMode() {
        return this.unixMode;
    }

    public void setUnixMode(Integer unixMode) {
        this.unixMode = unixMode;
    }

    public String getUnixUser() {
        return this.unixUser;
    }

    public void setUnixUser(String unixUser) {
        this.unixUser = unixUser;
    }

    public String getUnixGroup() {
        return this.unixGroup;
    }

    public void setUnixGroup(String unixGroup) {
        this.unixGroup = unixGroup;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getZosDeployType() {
        return this.zosDeployType;
    }

    public void setZosDeployType(String zosPdsType) {
        this.zosDeployType = zosPdsType;
    }

    public String getZosDeployAction() {
        return this.zosDeployAction;
    }

    public void setZosDeployAction(String zosDeployAction) {
        this.zosDeployAction = zosDeployAction;
    }

    public String getZosContainerType() {
        return this.zosContainerType;
    }

    public void setZosContainerType(String zosContainerType) {
        this.zosContainerType = zosContainerType;
    }

    public JSONObject getUserAttributes() {
        String ua = this.getUserAttributes0();
        if (ua == null) {
            return null;
        }
        try {
            return new JSONObject(ua);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUserAttributes(JSONObject userAttributes) {
        if (userAttributes == null) {
            this.setUserAttributes0(null);
            return;
        }
        this.setUserAttributes0(userAttributes.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AggregateItemMeta) {
            AggregateItemMeta r = (AggregateItemMeta)obj;
            return this.type == r.type && this.path.equals(r.path);
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + this.type;
        hash = 31 * hash + this.path.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("FileItem{type=%s, path=%s}", Aggregate.typeToString(this.type), this.path);
    }

    public String toLongString() {
        String hash = "<undefined>";
        if (this.hash != null) {
            hash = this.hash;
        }
        String lastModified = "<undefined>";
        if (this.lastModified != 0L) {
            lastModified = String.valueOf(this.lastModified);
        }
        String unixMode = "<undefined>";
        if (this.unixMode != null) {
            unixMode = String.format("%04o", this.unixMode);
        }
        String unixUser = "<undefined>";
        if (this.unixUser != null) {
            unixUser = this.unixUser;
        }
        String unixGroup = "<undefined>";
        if (this.unixGroup != null) {
            unixGroup = this.unixGroup;
        }
        String charset = "<undefined>";
        if (this.charset != null) {
            charset = this.charset;
        }
        String zosPdsType = "<undefined>";
        if (this.zosDeployType != null) {
            zosPdsType = this.zosDeployType;
        }
        String zosDeployAction = "<undefined>";
        if (this.zosDeployAction != null) {
            zosDeployAction = this.zosDeployAction;
        }
        String zosContainerType = "<undefined>";
        if (this.zosContainerType != null) {
            zosContainerType = this.zosContainerType;
        }
        String userAttributes = "<undefined>";
        if (this.userAttributes != null) {
            userAttributes = this.userAttributes;
        }
        return String.format("FileItem{%n  type=%s%n  path=%s%n  lastModified=%s%n  hash=%s%n  unixMode=%s%n  unixUser=%s%n  unixGroup=%s%n  charset=%s%n  zosDeployType=%s%n  zosDeployAction=%s%n  zosContainerType=%s%n  userAttributes=%s%n}", Aggregate.typeToString(this.type), this.path, lastModified, hash, unixMode, unixUser, unixGroup, charset, zosPdsType, zosDeployAction, zosContainerType, userAttributes);
    }

    String getUserAttributes0() {
        return this.userAttributes;
    }

    void setUserAttributes0(String userAttributes) {
        this.userAttributes = userAttributes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private Object readResolve() throws ObjectStreamException {
        if (Aggregate.isPathValid(this.path)) {
            return this;
        }
        String ua = null;
        try {
            if (this.userAttributes != null) {
                ua = new JSONObject(this.userAttributes).toString();
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        String p = Aggregate.unsafeSanitize(this.path);
        AggregateItemMeta r = new AggregateItemMeta(this.type, p);
        r.lastModified = this.lastModified;
        r.hash = this.hash;
        r.unixMode = this.unixMode;
        r.unixUser = this.unixUser;
        r.unixGroup = this.unixGroup;
        r.charset = this.charset;
        r.zosDeployType = this.zosDeployType;
        r.zosDeployAction = this.zosDeployAction;
        r.zosContainerType = this.zosContainerType;
        r.userAttributes = ua;
        return r;
    }

    static {
        StringBuilder b = new StringBuilder();
        b.append("com.");
        b.append("urbancode.");
        b.append("codestation2.");
        b.append("common.");
        b.append("aggregate.");
        b.append("AggregateItemMeta");
        String expected = b.toString();
        String name = AggregateItemMeta.class.getName();
        if (!name.equals(expected)) {
            throw new Error("Serialized class name changed: name=" + name + ", expected=" + expected);
        }
    }
}

