/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;

class SharedFileReader {
    private SeekableInputStream in;
    private long position;
    private int refcnt;

    SharedFileReader(SeekableInputStream in) {
        this.in = in;
        this.position = -1L;
    }

    int pread(long pos) throws IOException {
        int b;
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        if (this.position == -1L) {
            return -1;
        }
        if (pos != this.position) {
            this.in.seek(pos);
            this.position = pos;
        }
        if ((b = this.in.read()) != -1) {
            ++this.position;
        }
        return b;
    }

    int pread(byte[] b, long pos) throws IOException {
        return this.pread(b, 0, b.length, pos);
    }

    int pread(byte[] b, int off, int len, long pos) throws IOException {
        int count;
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        if (this.position == -1L) {
            return -1;
        }
        if (pos != this.position) {
            this.in.seek(pos);
            this.position = pos;
        }
        if ((count = this.in.read(b, off, len)) != -1) {
            this.position += (long)count;
        }
        return count;
    }

    void incref() throws IOException {
        if (this.refcnt == 0) {
            this.position = 0L;
        }
        ++this.refcnt;
    }

    void decref() throws IOException {
        if (this.refcnt == 0) {
            throw new IllegalStateException();
        }
        --this.refcnt;
        if (this.refcnt <= 0) {
            SeekableInputStream i = this.in;
            this.in = null;
            this.position = -1L;
            if (i != null) {
                i.close();
            }
        }
    }
}

