/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.plugins.ucd.vfs;

import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.plugins.ucd.vfs.Util;
import com.urbancode.plugins.ucd.vfs.ZosDownloadHelper;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class DownloadForZosCommand {
    static final int ERR_CODE = 1;

    public static void main(String[] args) {
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties props = apTool.getStepProperties();
            String repositoryType = StringUtils.trimToNull((String)props.getProperty("repositoryType"));
            String versionName = StringUtils.trimToNull((String)props.getProperty("versionName"));
            UUID versionId = UUID.fromString(StringUtils.trimToNull((String)props.getProperty("versionId")));
            String resourceId = StringUtils.trimToNull((String)props.getProperty("resourceId"));
            String directoryOffset = StringUtils.trimToNull((String)props.getProperty("directoryOffset"));
            String serverUrl = Util.parseServerUrl(props.getProperty("serverUrl"));
            Charset charset = Util.getCharset(props);
            ZosDownloadHelper zosDownloadHelper = new ZosDownloadHelper(repositoryType, versionName, versionId, resourceId, directoryOffset, serverUrl, charset, apTool, true);
            zosDownloadHelper.downloadVersion();
            if (zosDownloadHelper.isSecondVersion()) {
                zosDownloadHelper.extractVersion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

